package acao.turma;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.Turma_AlunoModel;
import slave.Dominio;
import acao.Acao;
import dto.*;
import dto.TurmaDTO;
import dto.Turma_AlunoDTO;

public class VincularAlunoTurmaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		Turma_AlunoModel model = new Turma_AlunoModel(login);
		
		Turma_AlunoDTO dto = new Turma_AlunoDTO();
		TurmaDTO turma = (TurmaDTO)req.getSession().getAttribute("turma");
		
		dto.setChavePessoaAluno(new Integer(req.getParameter("chavePessoa")));
		dto.setCodigoTurma(turma.getCodigoTurma());
		dto.setCodigoCurso(turma.getCodigoCurso());
		dto.setIdDisciplina(turma.getIdDisciplina());
		dto.setAno(turma.getAno());
		dto.setSemestre(turma.getSemestre());
		
		req.getSession().removeAttribute("turma");
		try{
			model.cadastrarCurso_DisciplinaDAO(dto);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarTurma.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarAlunoDaTurma.do?codigoTurma="+dto.getCodigoTurma()+"&codigoCurso="+dto.getCodigoCurso()+"&idDisciplina="+dto.getIdDisciplina()+"&ano="+dto.getAno()+"&semestre="+dto.getSemestre()+"";
	}
}
