package action;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import model.LoginModel;
import slave.Dominio;
import dto.LoginDTO;
import dto.PessoaDTO;
import acao.Acao;

import mina.mail.*;
import mina.view.MailContent;

public class RecoverPasswordAction implements Acao{
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		PessoaDTO person = new PessoaDTO();
		if(req.getParameter("mail")!=null) {
			LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
			person.setEmail(req.getParameter("mail"));
		
			LoginModel model = new LoginModel(login);
		
			try{
				login = model.recoverLogin(person);
			}catch (SQLException e) {
				e.printStackTrace();
				req.setAttribute("message",Dominio.getMensagemErroNaBaseDeDados());
				return "/jsp/recoverPassword.jsp";
			}
		
			if(login.getSenha() == null){
				req.setAttribute("message","No existe nenhum usurio cadastrado com o e-mail "+person.getEmail()+".");
				return "/jsp/recoverPassword.jsp";
			}else{
				try{
					this.sendPassword(person,login);
					req.setAttribute("mensagem","Sua senha foi enviada para o e-mail "+person.getEmail()+".");
					return "/jsp/login.jsp";
				}  
				catch (Exception e) {  
					e.printStackTrace();
					req.setAttribute("message","Infelizmente no podemos enviar a sua senha para seu e-mail "+person.getEmail()+". Entre em contato pelo nosso e-mail.");
					return "/jsp/recoverPassword.jsp";
				}
			}
		}
		else
		{
			return "/jsp/recoverPassword.jsp";
		}
	}
	
	private void sendPassword(PessoaDTO person, LoginDTO login) throws Exception
	{
		Mail mail = new Mail();
		mail.sendSingle(person,MailContent.getRecoverPassword(login),"Sua senha do SAE!");
	}
}