package chat.acao;

import java.util.Collections;
import java.util.Iterator;

import javax.servlet.http.*;

import slave.VisaoApoioProjetoMaior;
import acao.Acao;
import chat.dto.*;
import dto.PessoaDTO;

public class FramePrincipalAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		HttpSession secao = req.getSession();
		Integer perfil = (Integer)secao.getAttribute("perfil");
		
		req.getSession().setAttribute("acaoAnterior","FramePrincipalAcao");
		secao.setAttribute("chatAberto", "true");
			
		PessoaDTO pessoa = VisaoApoioProjetoMaior.carregaPessoaPeloPerfil(secao, perfil);
		//usuario
		Integer chaveUsuario = pessoa.getChavePessoa();
		String loginUsuario = pessoa.getApelido();
		
		if(chaveUsuario==null || chaveUsuario.intValue()<1){
			req.setAttribute("mensagemInicial", "Informe um login");
			return "/jsp/chat/confirmaLogin.jsp";
		}
		
		SessaoDTO sessaoAtual = (SessaoDTO)req.getSession().getAttribute("sessao");
		if(sessaoAtual==null){
			if(isChaveJaExiste(chaveUsuario)){
				req.setAttribute("mensagemInicial", "Usurio j logado no chat! Confirme sua senha caso queira entrar novamente!");
				return "/jsp/chat/confirmaLogin.jsp";
			}
		}
			
		//S adiciona login na lista se a sessao no existir
		if(!ApoioServidorDTO.getListaSessoes().contains(sessaoAtual)){
			//Usuario
			UsuarioDTO usuario = carregaUsuario(req, loginUsuario, chaveUsuario, perfil);
		
			//SessaoDTO
			SessaoDTO sessao = carregaSessao(req, usuario);
		
			ApoioServidorDTO.getListaUsuarios().add(usuario);
			Collections.sort(ApoioServidorDTO.getListaUsuarios());
			ApoioServidorDTO.getListaSessoes().add(sessao);
		}
		return "/jsp/chat/framePrincipal.jsp";
	}

	private SessaoDTO carregaSessao(HttpServletRequest req, UsuarioDTO usuario) {
		SessaoDTO sessao = new SessaoDTO();
		sessao.setUsuarioSessao(usuario);
		sessao.setSessao(req.getSession());
		req.getSession(true).setAttribute("sessao", sessao);
		return sessao;
	}

	private UsuarioDTO carregaUsuario(HttpServletRequest req, String loginUsuario, Integer chaveUsuario, Integer perfil) {
		UsuarioDTO usuario = new UsuarioDTO();
		usuario.setChaveUsuario(chaveUsuario);
		usuario.setLogin(loginUsuario);
		usuario.setPerfil(perfil);
		req.getSession(true).setAttribute("usuario", usuario);
		return usuario;
	}
	
	private boolean isChaveJaExiste(Integer chaveUsuario){
		Iterator it = ApoioServidorDTO.getListaUsuarios().iterator();
		while(it.hasNext()){
			UsuarioDTO usuarioTemp = (UsuarioDTO)it.next();
			
			//Login j existente no chat
			if(usuarioTemp.getChaveUsuario().intValue()==chaveUsuario.intValue()){
				return true;
			}
		}
		return false;
	}
}