package chat.acao;

import java.util.Iterator;

import javax.servlet.http.*;

import acao.Acao;
import chat.controlador.UtilChat;
import chat.dto.*;

public class FrameTextAreaAcao implements Acao {

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		//Testando sessao ativa
		HttpSession sessao = req.getSession();
		if(isSessaoExcluidaDaLista(sessao)){
			return "erroFechaChat.do";
		}
		
		//Buscando informaes da sesso
		UsuarioDTO usuario = (UsuarioDTO) req.getSession().getAttribute("usuario");
		String destinatario = (String) req.getSession().getAttribute("destinatario");
		String chaveDestinatarioString = (String) req.getSession().getAttribute("chaveDestinatario");
		
		Integer chaveDestinatario = null;
		if(chaveDestinatarioString!=null)
			chaveDestinatario = new Integer(chaveDestinatarioString);
		String reservado = (String) req.getSession().getAttribute("reservado");
		String texto = req.getParameter("texto");
		//String textoSaida = req.getParameter("textoSaida"); //SERA USADO NA INTEGRAO

		//Usuario no logado
		if (usuario == null) {
			req.setAttribute("mensagemInicial", "Informe um login");
			return "login.do";
		}
   
		String remetente = usuario.getLogin();
		Integer chaveRemetente = usuario.getChaveUsuario();

		//Testando nome para destinatrio
		if (destinatario == null)
			destinatario = "TODOS";

		String textoFinal = montaMensagemFinal(destinatario, remetente, texto, reservado, req
				.getSession());
		
		String textoFinalDestacado = montaMensagemFinalDestacado(destinatario, remetente, texto, reservado, req
				.getSession());
		
		sessao.removeAttribute("reconectar");
		
		if (textoFinal != null) {
			if (isMensagemReservada(reservado) && !destinatario.equalsIgnoreCase("todos"))
				carregaMensagemReservada(textoFinalDestacado, remetente,chaveRemetente, destinatario, chaveDestinatario);
			else
				carregaBroadcastDeMensagens(textoFinal,textoFinalDestacado,chaveRemetente,chaveDestinatario);
		}

		return "/jsp/chat/frameTextArea.jsp";
	}

	private boolean isSessaoExcluidaDaLista(HttpSession sessao) {
		Iterator it = ApoioServidorDTO.getListaSessoes().iterator();
		while(it.hasNext()){
			SessaoDTO sessaoTemp = (SessaoDTO)it.next();
			if(sessaoTemp.getSessao().equals(sessao)){
				return false;
			}
		}
		return true;
	}

	private void carregaBroadcastDeMensagens(String textoFinal,String textoFinalDestacado,Integer chaveRemetente,Integer chaveDestinatario) {
		UtilChat.carregaBroadcastDeMensagens(textoFinal,textoFinalDestacado, chaveRemetente, chaveDestinatario);
	}

	private void carregaMensagemReservada(String textoFinal, String remetente, Integer chaveRemetente, String destinatario, Integer chaveDestinatario) {
		LogMensagensDTO logMensagens;
		Iterator it = ApoioServidorDTO.getListaSessoes().iterator();
		while (it.hasNext()) {
			SessaoDTO sessao = (SessaoDTO) it.next();
			try {
				if (isPessoasDaMensagemReservada(chaveRemetente, chaveDestinatario,destinatario, sessao)) {
					finalizaCarregaMenssagemReservada(textoFinal, sessao);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private void finalizaCarregaMenssagemReservada(String textoFinal, SessaoDTO sessao) {
		LogMensagensDTO logMensagens;
		logMensagens = carregaLogDasSessoesParaSerAlterado(sessao.getSessao());
		logMensagens.adicionaMensagemAoLog(textoFinal);
		sessao.getSessao().setAttribute("logMensagens", logMensagens);
		sessao.getSessao().setAttribute("texto", logMensagens.recuperaLogMensagens());
	}

	private boolean isPessoasDaMensagemReservada(Integer chaveRemetente, Integer chaveDestinatario, String destinatario, SessaoDTO sessao) {
		return sessao != null && (sessao.getUsuarioSessao().getChaveUsuario().equals(chaveDestinatario)
						|| sessao.getUsuarioSessao().getChaveUsuario().equals(chaveRemetente) 
						|| destinatario.equalsIgnoreCase("todos"));
	}

	private LogMensagensDTO carregaLogDasSessoesParaSerAlterado(HttpSession sessao) {
		LogMensagensDTO logMensagens = (LogMensagensDTO) sessao.getAttribute("logMensagens");
		if (logMensagens == null) {
			logMensagens = new LogMensagensDTO();
		}
		return logMensagens;
	}

	private String montaMensagemFinal(String destinatario, String remetente, String texto, String reservado, HttpSession sessaoTemp) {
		LogMensagensDTO logMensagens = carregaLogDasSessoesParaSerAlterado(sessaoTemp);
		if (isUsuarioEntrandoNoChat(texto, logMensagens)){
			String reconectar = (String)sessaoTemp.getAttribute("reconectar");
			
			if(reconectar==null)
				return UtilChat.montaMensagemEntrada(remetente);
			return UtilChat.montaMensagemReconexao(remetente);
		}

		if (isMensagemReservada(reservado) && texto!=null){
			if(destinatario.equalsIgnoreCase("todos"))
				return UtilChat.montaCabecalhoMensagemReservadaSemDestaque(remetente, destinatario, texto);
			return UtilChat.montaCabecalhoMensagemReservadaDestacada(remetente, destinatario, texto); 
		}
		
		return UtilChat.montaCabecalhoPadraoMensagem(remetente, destinatario, texto);
	}
	
	private String montaMensagemFinalDestacado(String destinatario, String remetente, String texto, String reservado, HttpSession sessaoTemp) {
		LogMensagensDTO logMensagens = carregaLogDasSessoesParaSerAlterado(sessaoTemp);
		if (isUsuarioEntrandoNoChat(texto, logMensagens)){
			String reconectar = (String)sessaoTemp.getAttribute("reconectar");
			
			if(reconectar==null)
				return UtilChat.montaMensagemEntradaDestacado(remetente);
			return UtilChat.montaMensagemReconexaoDestacado(remetente);
		}

		if (isMensagemReservada(reservado) && texto!=null && !destinatario.equalsIgnoreCase("todos"))
			return UtilChat.montaCabecalhoMensagemReservadaDestacada(remetente, destinatario, texto);

		return UtilChat.montaCabecalhoPadraoMensagemDestacada(remetente, destinatario, texto);
	}

	protected boolean isMensagemReservada(String reservado) {
		return reservado != null && reservado.equals("true");
	}

	protected boolean isUsuarioEntrandoNoChat(String texto, LogMensagensDTO logMensagens) {
		return texto == null && logMensagens.recuperaLogMensagens() == null;
	}

}