package chat.acao;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import acao.Acao;
import chat.dto.ApoioServidorDTO;
import chat.visao.VisaoChat;


public class FrameUsuariosAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		//TODO: por enquanto ser passado o nome do destinatrio, futuramente ser o id
		String destinatario = req.getParameter("destinatario");
		String chaveDestinatario = req.getParameter("chaveDestinatario");
		String reservado = req.getParameter("reservado");
		
		//TODO: verificar se quando mandar mensagem para TODOS poder ser reservada ou no, caso no descomentar linha
		if(destinatario!=null && !destinatario.equalsIgnoreCase("todos")){
			req.getSession().setAttribute("destinatario", destinatario);
			req.getSession().setAttribute("chaveDestinatario", chaveDestinatario);
		}else{
			testaRetirarCamposUsuarioEReservado(req, destinatario, chaveDestinatario);
		}
		
		if(reservado!=null)
			req.getSession().setAttribute("reservado", reservado);
		
		req.getSession().setAttribute("listaUsuarios", ApoioServidorDTO.getListaUsuarios());
		
		if(destinatario!=null || reservado!=null)
			return "/textoUsuariosChat.do?i="+Math.random();	
		
		return "/jsp/chat/frameUsuarios.jsp";	
	}

	private void testaRetirarCamposUsuarioEReservado(HttpServletRequest req, String destinatario, String chaveDestinatario) {
		VisaoChat visao = new VisaoChat();
		 //Teste para tirar os usuario do reservado caso o outro usuario no exista mais na sala
		if(destinatario!=null && destinatario.equalsIgnoreCase("todos")){
			req.getSession().setAttribute("destinatario",null);
			req.getSession().setAttribute("chaveDestinatario",null);
		}else if(chaveDestinatario!=null && !visao.isDestinatarioNaListaUsuario(chaveDestinatario)){
			req.getSession().setAttribute("reservado",null);
			req.getSession().setAttribute("destinatario",null);
			req.getSession().setAttribute("chaveDestinatario",null);
		}
	}
	
}
