package chat.acao;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import acao.Acao;
import chat.controlador.UtilChat;
import chat.dto.ApoioServidorDTO;
import chat.dto.SessaoDTO;

public class SairChatAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		//Este controle se faz necessrio pelo fato do unload tambm ser executado no submit da pagina
		String acaoAnterior = (String)req.getSession().getAttribute("acaoAnterior"); //Para saber se a acao anterior  ControlaAbrirChatAcao para no executar a rotina sair
		String chatAberto = (String)req.getSession().getAttribute("chatAberto");
	
		if((chatAberto!=null && acaoAnterior==null) || acaoAnterior!=null && acaoAnterior.equalsIgnoreCase("FramePrincipalAcao") || acaoAnterior!=null && acaoAnterior.equalsIgnoreCase("SairChatAcao")){
			SessaoDTO sessaoAtual = (SessaoDTO)req.getSession().getAttribute("sessao");
			if(sessaoAtual!=null){
	    		String usuarioSaida = sessaoAtual.getUsuarioSessao().getLogin();
		    	boolean isUsuarioRemovido = ApoioServidorDTO.getListaUsuarios().remove(sessaoAtual.getUsuarioSessao());
		    	boolean isSessaoRemovida = ApoioServidorDTO.getListaSessoes().remove(sessaoAtual);
	    		
		    	if(isUsuarioRemovido && isSessaoRemovida)
	    			carregaBroadcastDeMensagensParaSaidaDeUsuario(usuarioSaida);
		    	
		    	req.getSession().removeAttribute("logMensagens");
		    	req.getSession().removeAttribute("sessao");
		    	req.getSession().removeAttribute("chat");
		    	req.getSession().removeAttribute("chatAberto");
		    	req.getSession().removeAttribute("acaoAnterior");
		    	req.getSession().removeAttribute("reservado");
		    	req.getSession().removeAttribute("destinatario");
		    	req.getSession().removeAttribute("chaveDestinatario");
		    	req.getSession().removeAttribute("reconectar");
			}
//			return "frameMensagensChat.do";
		}
		
		if(acaoAnterior!=null && acaoAnterior.equalsIgnoreCase("FramePrincipalAcao")){
			req.getSession().removeAttribute("acaoAnterior");
			acaoAnterior=null;
		}
		
		
		if(acaoAnterior!=null && acaoAnterior.equalsIgnoreCase("SairChatAcao")){
//			req.getSession().setAttribute("acaoAnterior","FramePrincipalAcao");
			req.getSession().removeAttribute("acaoAnterior");
			acaoAnterior=null;
			
		}
		
		if(acaoAnterior!=null && acaoAnterior.equalsIgnoreCase("ControladorAbrirChatAcao"))
			req.getSession().setAttribute("acaoAnterior","SairChatAcao");
		
		return "/jsp/chat/framePrincipal.jsp";
	}
	
	private void carregaBroadcastDeMensagensParaSaidaDeUsuario(String usuarioSaida) {
		UtilChat.carregaBroadcastDeMensagens(UtilChat.montaMensagemSaida(usuarioSaida),null,null,null);
	}

}