package chat.acao;

import java.util.Iterator;

import javax.servlet.http.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import chat.dto.ApoioServidorDTO;
import chat.dto.SessaoDTO;

import acao.Acao;

public class TextoMensagemChatAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession sessao = req.getSession();
		if(isSessaoExcluidaDaLista(sessao))
			return "erroFechaChat.do";
		else{
			req.setAttribute("texto",req.getSession().getAttribute("texto"));
			return "/jsp/chat/textoMensagemChat.jsp";
		}
	}
	
	private boolean isSessaoExcluidaDaLista(HttpSession sessao) {
		Iterator it = ApoioServidorDTO.getListaSessoes().iterator();
		while(it.hasNext()){
			SessaoDTO sessaoTemp = (SessaoDTO)it.next();
			if(sessaoTemp.getSessao().equals(sessao)){
				return false;
			}
		}
		return true;
	}

}