package chat.controlador;

import java.io.IOException;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

import chat.dto.ApoioServidorDTO;
import chat.dto.SessaoDTO;


public class ListenerControlaSessao implements HttpSessionListener { 
	    private static List sessions = new ArrayList(); 

	    public void sessionCreated(HttpSessionEvent se) {
	    	System.out.println("Session Create");
	    } 

	    public void sessionDestroyed(HttpSessionEvent se) { 
	    	System.out.println("Session Destroyed");
	    	HttpSession secao = se.getSession();
	    	SessaoDTO sessaoParaExclusao = carregaSessaoDTOParaExclusao(se);
	    	if(sessaoParaExclusao!=null){
	    		String usuarioSaida = sessaoParaExclusao.getUsuarioSessao().getLogin();
		    	ApoioServidorDTO.getListaUsuarios().remove(sessaoParaExclusao.getUsuarioSessao());
		    	ApoioServidorDTO.getListaSessoes().remove(sessaoParaExclusao);
		    	carregaBroadcastDeMensagensParaSaidaDeUsuario(usuarioSaida);
		    	
		    	//Removendo atributos da sesso caso ela seja invalidada
				secao.removeAttribute("loginDTO");
				secao.removeAttribute("perfil");
	    		secao.removeAttribute("logMensagens");
	    		secao.removeAttribute("sessao");
	    		secao.removeAttribute("chat");
	    		secao.removeAttribute("chatAberto");
	    		secao.removeAttribute("acaoAnterior");
	    		secao.removeAttribute("reservado");
	    		secao.removeAttribute("destinatario");
	    		secao.removeAttribute("chaveDestinatario");
	    	}
	    } 
	    
	    private void carregaBroadcastDeMensagensParaSaidaDeUsuario(String usuarioSaida) {
			UtilChat.carregaBroadcastDeMensagens(UtilChat.montaMensagemSaida(usuarioSaida),null,null,null);
		}

	    public void doFilter(ServletRequest req, ServletResponse res, 
	            FilterChain chain) throws IOException, ServletException { 
	        
	        HttpServletRequest sreq = (HttpServletRequest) req; 
	        final String servletPath = sreq.getServletPath(); 
	        if (!"/reqLogout.do".equals(servletPath)) { 
	        	HttpSession session = sreq.getSession(); 
	            String sessionId = session.getId(); 
	            if (!sessions.contains(sessionId)) { 
	            	System.gc(); 
	                ((HttpServletResponse) res).sendRedirect("reqLogout.do?cause=errors.low.memory"); 
	                return; 
	            } 
	        } 
	        chain.doFilter(sreq, res); 
	    } 

	    private SessaoDTO carregaSessaoDTOParaExclusao(HttpSessionEvent se){
	    	SessaoDTO sessaoTemp;
	    	Iterator it = ApoioServidorDTO.getListaSessoes().iterator();
	    	while(it.hasNext()){
	    		sessaoTemp = (SessaoDTO)it.next();
		    	if(sessaoTemp.getSessao().equals(se.getSession())){
		    		return sessaoTemp;
		    	}
	    	}
	    	return null;
	    }

} 


