package controlador;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.servlet.ServletException;

/**
 * Classe responsavel por controlar o pool de Acoes da aplicacao.
 * 
 * @author Jeysel
 */
public class AcaoPool {

	Properties acoes = new Properties();

	private static AcaoPool AcoesPool;

	/**
	 * singleton
	 *  
	 */
	private AcaoPool() {
	}

	/**
	 * metodo para implementacao do singleton
	 * 
	 * @return
	 */
	public static AcaoPool getInstance() {
		if (AcoesPool == null) {
			AcoesPool = new AcaoPool();
		}
		return AcoesPool;
	}

	/**
	 * Efetua a leitura de todos os Acoes do arquivo de properties
	 * 
	 * @throws ServletException
	 *  
	 */
	public void carregarAcoes(String arquivo) throws ServletException {
		try {
			if (arquivo == null) {
				throw new ServletException(
						"No foi possivel encontrar no descritor a variavel de inicializacao 'acoes'");
			}
			InputStream str = this.getClass().getClassLoader().getResourceAsStream(arquivo);
			//ResourceBundle rb = ResourceBundle.getBundle("acoes");
			if (str == null) {
				throw new ServletException(
						"No foi possivel encontrar o arquivo de acoes 'acoes.properties'");
			}
			//System.out.println(rb.getString("ola"));
			acoes.load(str);
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	/**
	 * Obtem uma Acao a partir da chave informada
	 * 
	 * @param chave
	 * @return
	 */
	public String obter(String chave) {
		return (String) acoes.get(chave);
	}
}