package controlador;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.*;

import chat.acao.*;

import seguranca.SegurancaGeral;
import acao.*;
import action.*;

/**
 * Classe Controladora responsavel por receber uma requisicao e redireciona-la.
 * Implementa o padrao FrontController para controle de requisicoes e Service To
 * Worker para delegaao das acoes de Acao
 * 
 * @author Jeysel
 */
public class Controlador extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;//frescura da maquina virtual

	/**
	 * Metodo de inicializacao do servlet Efetua a carga dos Acoes
	 */
	public void init() throws ServletException {
		carregarAcoes();
	}

	/**
	 * Efetua a carga dos Acoes invocando o AcaoPool
	 * 
	 * @throws ServletException
	 *  
	 */
	private void carregarAcoes() throws ServletException {
		AcaoPool.getInstance().carregarAcoes(getInitParameter("acoes"));
	}

	/**
	 * metodo padrao do servlet que recebe requisicoes do tipo post
	 */
	public void doPost(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		processRequest(req, resp);
	}

	/**
	 * metodo padrao do servlet que recebe requisicoes do tipo get
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		processRequest(req, resp);
	}

	/**
	 * Centralizador das requisicoes do servlet
	 * 
	 * @param req
	 * @param resp
	 * @throws ServletException
	 */
	private void processRequest(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException {
		try {
//			Enumeration enum = req.getHeaderNames();
//			while(enum.hasMoreElements()){
//				System.out.println(	enum.nextElement());
//			}
			
			String chave = getChaveAcao(req);
			Acao acao = localizarAcao(chave);

			if(((acao instanceof LogarAcao)|(acao instanceof IndexAcao))|(acao instanceof RecoverPasswordAction)){
				despachar(req, resp, acao);
			}else{
				if(SegurancaGeral.isLogado(req))
					despachar(req, resp, acao);
				else
					if(acao instanceof TextoMensagemChatAcao)
						despachar(req, resp, new ErroChatAcao());
					else if(acao instanceof TextoUsuariosChatAcao)
						despachar(req, resp, new ErroChatPaginaEmBrancoAcao());
					else
						despachar(req, resp, new IndexAcao());
			}
			//despachar(req, resp, acao);	
		} catch (Exception e) {
			e.printStackTrace();
         			throw new ServletException(e.getMessage());
		}

	}

	/**
	 * Localiza um Acao a partir da chave informada. Utiliza o AcaoPool
	 * 
	 * @param chave
	 * @return
	 */
	private Acao localizarAcao(String chave) throws ServletException {
		Class classe;
		String acao = AcaoPool.getInstance().obter(chave);
		try {
			if (acao == null) {
				throw new ServletException(
						"No foi possivel encontrar a Acao para a chave '" + chave
								+ "'");
			}
			System.out.println("Executando Acao - "+acao);
			classe = Class.forName(acao);
			Acao AcaoClass = (Acao) classe.newInstance();
			return AcaoClass;

		} catch (ServletException e) {
			throw e;
		} catch (ClassNotFoundException e) {
			throw new ServletException(
					"No foi possivel encontrar a classe da chave '" + chave + "' com o nome '" + acao + "'");
		} catch (InstantiationException e) {
			throw new ServletException(
					"No foi possivel encontrar a Acao da chave '" + chave);
		} catch (IllegalAccessException e) {
			throw new ServletException(
					"No foi possivel encontrar a Acao da chave '" + chave);
		}

	}

	/**
	 * Efetua a leitura da chave do Acao a partir da URL
	 * 
	 * @param req
	 * @return
	 * @throws IOException
	 */
	private String getChaveAcao(HttpServletRequest req) throws IOException {
		int inicio = req.getRequestURI().lastIndexOf("/");
		int fim = req.getRequestURI().lastIndexOf(".do");
		return req.getRequestURI().substring(inicio + 1, fim);
	}

	/**
	 * Redireciona a requisicao para a jsp retornada pelo metodo executar do
	 * Acao
	 * 
	 * @param req
	 * @param resp
	 * @param Acao
	 * @return
	 * @throws Exception
	 */
	public void despachar(HttpServletRequest req, HttpServletResponse resp,
			Acao acao) throws Exception {
		String proximaPagina =  acao.executar(req, resp);
		req.getRequestDispatcher(proximaPagina).forward(req, resp);
	}

}