package dao;

import java.sql.*;

import dto.AdministradorDTO;

public class AdministradorDAO extends DAOBase{

	public static final String SQL_BUSCARADMINISTRADOR= "SELECT A.chavePessoa ,A.nomePessoa, A.apelido, A.dtNascer, A.cpf, A.sexo, A.situacao, A.email, A.webPessoal, B.dtRegistro FROM maiorPessoa A, maiorAdministrador B WHERE A.chavePessoa = B.chavePessoa AND A.chavePessoa = ? ORDER BY A.nomePessoa ";
	
	public AdministradorDTO buscarAdministrador(Integer chavePessoa) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARADMINISTRADOR);
		ps.setInt(1,chavePessoa.intValue());
		ResultSet rs = ps.executeQuery();
		AdministradorDTO dto = new AdministradorDTO();
		if(rs.next())
			put(rs,dto);
		return dto;
	}
	
	private void put(ResultSet rs, AdministradorDTO dto) throws SQLException {
		dto.setChavePessoa(new Integer(rs.getInt("chavePessoa")));
		dto.setApelido(rs.getString("apelido"));
		dto.setNomePessoa(rs.getString("nomePessoa"));
		dto.setDtNascer(rs.getDate("dtNascer"));
		dto.setCpf(rs.getString("cpf"));
		dto.setSexo(rs.getString("sexo"));
		dto.setSituacao(rs.getString("situacao"));
		dto.setWebPessoal(rs.getString("webPessoal"));
		dto.setEmail(rs.getString("email"));
		dto.setDataRegistro(rs.getDate("dtRegistro"));

	}
}
