package dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import dto.AlunoDTO;

public class AlunoDAO extends DAOBase{
		
	public static final String SQL_CADASTRARALUNO = "INSERT INTO maiorAluno VALUES(?,?,?,?,?);";
	public static final String SQL_EXCLUIRALUNO = "DELETE FROM maiorAluno WHERE chavePessoa = ?";
	public static final String SQL_BUSCAALUNO = "SELECT A.chavePessoa, A.nomePessoa, A.dtNascer, A.cpf, A.sexo, A.email, B.situacao,A.apelido, A.webPessoal,B.dtRegistro, B.codigoCurso, B.matricula FROM maiorPessoa A, maiorAluno B WHERE A.chavePessoa = ? AND A.chavePessoa = B.chavePessoa ORDER BY A.nomePessoa";
	public static final String SQL_ALTERAALUNO = "UPDATE maiorAluno SET dtRegistro = ?, codigoCurso = ?, matricula = ?, situacao =  ? WHERE (chavePessoa = ?)";
	public Collection buscarAlunoPorNome(String nomeAluno) throws SQLException {
		String SQL_BUSCARALUNOPORNOME = "SELECT A.chavePessoa, A.nomePessoa, A.dtNascer, A.cpf, A.sexo, B.situacao, A.email, A.apelido," +
				"A.webPessoal,B.dtRegistro, B.codigoCurso, B.matricula FROM maiorPessoa A, maiorAluno B WHERE A.nomePessoa " +
				"LIKE '%"+nomeAluno+"%' AND A.chavePessoa = B.chavePessoa ORDER BY A.nomePessoa ";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARALUNOPORNOME);
		AlunoDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new AlunoDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		return col;
	}
	

	public Collection buscarAlunoPorNomeMatricula(String nomeAluno, String matricula) throws SQLException {
		String SQL_BUSCARALUNOPORNOMEMATRICULA = "SELECT A.chavePessoa, A.nomePessoa, A.dtNascer, A.cpf, A.sexo, B.situacao, A.email, A.apelido," +
		"A.webPessoal,B.dtRegistro, B.codigoCurso, B.matricula FROM maiorPessoa A, maiorAluno B WHERE" +
		" A.nomePessoa LIKE '%"+nomeAluno+"%' AND A.chavePessoa = B.chavePessoa " +
				"AND B.matricula ='"+matricula+"' ORDER BY A.nomePessoa ";
		 
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARALUNOPORNOMEMATRICULA);
		AlunoDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new AlunoDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		return col;
	}
	
	public AlunoDTO buscarAluno(Integer chavePessoa) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAALUNO);
		ps.setInt(1,chavePessoa.intValue());
		ResultSet rs = ps.executeQuery();
		AlunoDTO dto = new AlunoDTO();
		if(rs.next())
			putDto(rs,dto);
		return dto;
		
	}
	public void alterarAluno(AlunoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERAALUNO);
		ps.setDate(1,dto.getDtRegistro());
		ps.setInt(2,dto.getCodigoCurso().intValue());
		ps.setString(3,dto.getMatricula());
		ps.setString(4,dto.getSituacao());
		ps.setInt(5,dto.getChavePessoa().intValue());
		ps.executeUpdate();
	}
	public void excluir(Integer chavePessoa) throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_EXCLUIRALUNO);
		ps.setInt(1,chavePessoa.intValue());
		ps.executeUpdate();
		ps.close();
		
	}

	private void putDto(ResultSet rs, AlunoDTO dto) throws SQLException{
		dto.setChavePessoa(new Integer(rs.getInt("chavePessoa")));
		dto.setNomePessoa(rs.getString("nomePessoa"));
		dto.setDtNascer(rs.getDate("dtNascer"));
		dto.setCpf(rs.getString("cpf"));
		dto.setApelido(rs.getString("apelido"));
		dto.setSexo(rs.getString("sexo"));
		dto.setSituacao(rs.getString("situacao"));//pegando situacao de aluno nao de pessoa
		dto.setWebPessoal(rs.getString("webPessoal"));
		dto.setEmail(rs.getString("email"));
		dto.setDtRegistro(rs.getDate("dtRegistro"));
		dto.setCodigoCurso(new Integer(rs.getInt("codigoCurso")));
		dto.setMatricula(rs.getString("matricula"));
	}
	public Collection buscarAlunoPorMatricula(String matricula) throws SQLException {
		String SQL_BUSCARALUNOPORMATRICULA = "SELECT A.chavePessoa, A.nomePessoa, A.dtNascer, A.cpf, A.sexo, B.situacao, A.email, A.apelido," +
		"A.webPessoal,B.dtRegistro, B.codigoCurso, B.matricula FROM maiorPessoa A, maiorAluno B WHERE B.matricula ='"+matricula+
		"' AND A.chavePessoa = B.chavePessoa ORDER BY A.nomePessoa ";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARALUNOPORMATRICULA);
		
		AlunoDTO dto = new AlunoDTO();
		Collection col = new ArrayList();
		if(rs.next()){
			putDto(rs,dto);
			col.add(dto);
		}
		return col;
	}
	public void cadastrarAluno(AlunoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARALUNO);
		ps.setInt(1,dto.getChavePessoa().intValue());
		ps.setDate(2,dto.getDtRegistro());
		ps.setInt(3,dto.getCodigoCurso().intValue());
		ps.setString(4,dto.getMatricula());
		ps.setString(5,dto.getSituacao());
		ps.executeUpdate();	
	}






}
