package dao;

import java.sql.*;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;

import dto.AlunoDTO;

public class AlunoDaTurmaDAO extends DAOBase{
	
	public static final String SQL_CADASTRARALUNO = "insert into maiorAluno values(?,?,?,?,?);";
	public static final String SQL_EXCLUIRALUNO = "delete from maiorAluno where chavepessoa = ?";
	public static final String SQL_BUSCAALUNO = "select a.chavepessoa, a.nomepessoa, a.dtnascer, a.cpf, a.sexo, b.situacao, a.email, a.webpessoal,b.dtregistro, b.codigocurso, b.matricula from maiorPessoa a, maiorAluno b where a.chavepessoa = ? and a.chavepessoa = b.chavepessoa ORDER BY a.nomePessoa ";
	public static final String SQL_ALTERAALUNO = "update maiorAluno set dtregistro = ?, codigocurso = ?, matricula = ?, situacao =  ? where (chavepessoa = ?)";
	public Collection buscarAlunoPorNome(String nomeAluno) throws SQLException {
		String SQL_BUSCARALUNOPORNOME = "select a.chavepessoa, a.nomepessoa, a.dtnascer, a.cpf, a.sexo, b.situacao, a.email, " +
				"a.webpessoal,b.dtregistro, b.codigocurso, b.matricula from maiorPessoa a, maiorAluno b where a.nomepessoa " +
				"like '%"+nomeAluno+"%' and a.chavepessoa = b.chavepessoa ORDER BY a.nomePessoa";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARALUNOPORNOME);
		AlunoDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new AlunoDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		return col;
	}
	public Collection buscarAlunoDaTurmaPorNome(String nomeAluno,String codigoTurma, Integer codigoCurso, Integer idDisciplina, Integer ano, String semestre) throws SQLException {
		String SQL_BUSCARALUNOPORNOME = "select a.chavepessoa, a.nomepessoa, a.dtnascer, a.cpf, a.sexo, b.situacao, a.email, " +
				"a.webpessoal,b.dtregistro, b.codigocurso, b.matricula from maiorPessoa a, maiorAluno b " +
				"inner join maiorTurma_Aluno rel on b.chavepessoa=rel.chavepessoaaluno " +
				"where a.nomepessoa like '%"+nomeAluno+"%' and a.chavepessoa = b.chavepessoa " +
				"and rel.codigoturma = '"+codigoTurma+"' and rel.codigocurso = '"+codigoCurso+"' " +
				"and rel.iddisciplina = '"+idDisciplina+"' and rel.ano = '"+ano+"' and rel.semestre = '"+semestre+"' ORDER BY a.nomePessoa ";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARALUNOPORNOME);
		AlunoDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new AlunoDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		return col;
	}
	public AlunoDTO buscarAluno(Integer chavePessoa) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAALUNO);
		ps.setInt(1,chavePessoa.intValue());
		ResultSet rs = ps.executeQuery();
		AlunoDTO dto = new AlunoDTO();
		if(rs.next())
			putDto(rs,dto);
		return dto;
		
	}
	public void alterarAluno(AlunoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERAALUNO);
		ps.setDate(1,dto.getDtRegistro());
		ps.setInt(2,dto.getCodigoCurso().intValue());
		ps.setString(3,dto.getMatricula());
		ps.setString(4,dto.getSituacao());
		ps.setInt(5,dto.getChavePessoa().intValue());
		ps.executeUpdate();
	}
	public void excluir(Integer chavePessoa) throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_EXCLUIRALUNO);
		ps.setInt(1,chavePessoa.intValue());
		ps.executeUpdate();
		ps.close();
		
	}

	private void putDto(ResultSet rs, AlunoDTO dto) throws SQLException{
		dto.setChavePessoa(new Integer(rs.getInt("chavePessoa")));
		dto.setNomePessoa(rs.getString("nomePessoa"));
		dto.setDtNascer(rs.getDate("dtNascer"));
		dto.setCpf(rs.getString("cpf"));
		dto.setSexo(rs.getString("sexo"));
		dto.setSituacao(rs.getString("situacao"));//pegando situacao de aluno nao de pessoa
		dto.setWebPessoal(rs.getString("webPessoal"));
		dto.setEmail(rs.getString("email"));
		dto.setDtRegistro(rs.getDate("dtregistro"));
		dto.setCodigoCurso(new Integer(rs.getInt("codigoCurso")));
		dto.setMatricula(rs.getString("matricula"));
	}
	public Collection buscarAlunoPorMatricula(String matricula) throws SQLException {
		String SQL_BUSCARALUNOPORMATRICULA = "select a.chavepessoa, a.nomepessoa, a.dtnascer, a.cpf, a.sexo, b.situacao, a.email, " +
		"a.webpessoal,b.dtregistro, b.codigocurso, b.matricula from maiorPessoa a, maiorAluno b where b.matricula ='"+matricula+
		"' and a.chavepessoa = b.chavepessoa ORDER BY a.nomePessoa ";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARALUNOPORMATRICULA);
		rs.next();
		AlunoDTO dto = new AlunoDTO();
		putDto(rs,dto);
		Collection col = new ArrayList();
		col.add(dto);
		return col;
	}
	public Collection buscarAlunoDaTurmaPorMatricula(String matricula,String codigoTurma, Integer codigoCurso, Integer idDisciplina, Integer ano, String semestre) throws SQLException {
		String SQL_BUSCARALUNOPORMATRICULA = "select a.chavepessoa, a.nomepessoa, a.dtnascer, a.cpf, a.sexo, b.situacao, a.email, " +
		"a.webpessoal,b.dtregistro, b.codigocurso, b.matricula from maiorPessoa a, maiorAluno b " +
		"inner join maiorTurma_Aluno rel on b.chavepessoa=rel.chavepessoaaluno " +
		"where b.matricula ='"+matricula+"' and a.chavepessoa = b.chavepessoa " +
		"and rel.codigoturma = '"+codigoTurma+"' and rel.codigocurso = '"+codigoCurso+"' " +
		"and rel.iddisciplina = '"+idDisciplina+"' and rel.ano = '"+ano+"' and rel.semestre = '"+semestre+"' ORDER BY a.nomePessoa ";
		Statement stm = getConnection().createStatement();
		System.out.println(SQL_BUSCARALUNOPORMATRICULA);
		ResultSet rs = stm.executeQuery(SQL_BUSCARALUNOPORMATRICULA);
		rs.next();
		AlunoDTO dto = new AlunoDTO();
		putDto(rs,dto);
		Collection col = new ArrayList();
		col.add(dto);
		return col;
	}
	public void cadastrarAluno(AlunoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARALUNO);
		ps.setInt(1,dto.getChavePessoa().intValue());
		ps.setDate(2,dto.getDtRegistro());
		ps.setInt(3,dto.getCodigoCurso().intValue());
		ps.setString(4,dto.getMatricula());
		ps.setString(5,dto.getSituacao());
		ps.executeUpdate();	
	}
	public boolean isAlunoCatolicaVirtual(Integer chavePessoa) throws ParseException, SQLException {
		String SQL_BUSCARALUNODAUCBVIRTUAL = "SELECT * FROM maiorTurma_Aluno m " +
				"WHERE m.chavePessoaAluno ="+chavePessoa.intValue() +"  AND m.ano = "+ pmon.apoio.Data.getAno() +
				" AND m.semestre = "+pmon.apoio.Data.getSemestre()+
				" AND m.idDisciplina IN (17,18)";
		
		
		//System.out.println(SQL_BUSCARALUNODAUCBVIRTUAL);
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARALUNODAUCBVIRTUAL);
		if(rs.next()){
			return true;
		}else{
			return false;
		}
		
	}




}
