package dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import sti.dto.regra.RegraDTO;
import validacao.apoio.ApoioConteudo;
import dto.ConteudoDTO;

public class ConteudoDAO extends DAOBase{
	
	private static final String SQL_SETA_ULTIMA_ORDEM = "SELECT MAX(ordem) as maiorOrdem FROM maiorConteudo mc where mc.idDisciplina = ?";
	private static final String SQL_ALTERA_ORDEM = "update maiorConteudo set ordem = ? where ( idconteudo = ? )";
    private static final String SQL_ALTERARCONTEUDO = "update maiorConteudo set iddisciplina = ?, descricao = ? ,monitoria = ?, questoes = ? where ( idconteudo = ? )";
    private static final String SQL_DELETARCONTEUDO = "delete from maiorConteudo where idconteudo = ?";
    private static final String SQL_CADASTRARCONTEUDO = "insert into maiorConteudo values (?,?,?,?,?,?)";
    private static final String SQL_LISTARTODOSCONTEUDOS = "select * from maiorConteudo conteudo inner join maiorDisciplina disciplina on disciplina.idDisciplina=conteudo.idDisciplina order by conteudo.ordem";//disciplina.nomeDisciplina, conteudo.descricao;";
    private static final String SQL_BUSCARCONTEUDO = "select * from maiorConteudo conteudo inner join maiorDisciplina disciplina on disciplina.idDisciplina=conteudo.idDisciplina where idconteudo = ? order by conteudo.ordem";//disciplina.nomeDisciplina";
	
	public Collection listarTodosConteudos() throws SQLException{
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTARTODOSCONTEUDOS);
		Collection col = new ArrayList();
		ConteudoDTO dto;
		while(rs.next()){
			dto = new ConteudoDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public void cadastrarConteudo(ConteudoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARCONTEUDO);
		ps.setInt(1,0);//zero para autoincremento do Mysql
		ps.setInt(2,dto.getIdDisciplina().intValue());
		ps.setString(3,dto.getDescricao());
		ps.setInt(4,dto.getMonitoria().intValue());
		ps.setInt(5,dto.getQuestoes().intValue());
		ps.setInt(6,dto.getOrdem().intValue());//ordem
		ps.executeUpdate();
		ps.close();
	}
	
	public void excluirConteudo(Integer idConteudo) throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_DELETARCONTEUDO);
		ps.setInt(1,idConteudo.intValue());
		ps.executeUpdate();
		ps.close();

		
	}
	
	public ApoioConteudo buscarConteudo(Integer idConteudo) throws SQLException {
		ApoioConteudo dto = new ApoioConteudo();

		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARCONTEUDO);
		ps.setInt(1,idConteudo.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDtoApoio(rs,dto);
		rs.close();
		ps.close();
		return dto;
		
	}
	
	public void alterarConteudo(ConteudoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARCONTEUDO);
		ps.setInt(1,dto.getIdDisciplina().intValue());
		ps.setString(2,dto.getDescricao());
		ps.setInt(3,dto.getMonitoria().intValue());
		ps.setInt(4,dto.getQuestoes().intValue());
		ps.setInt(5,dto.getIdConteudo().intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public Collection buscarConteudosPorParteDescricaoENomeDisciplina(String nomeConteudo,String nomeDisciplina) throws SQLException {
		String SQL_BUSCARCONTEUDOSPORDESCRICAO = "select * from maiorConteudo conteudo "
				+ "inner join maiorDisciplina disciplina on conteudo.iddisciplina=disciplina.iddisciplina "
				+ "where conteudo.descricao like '%"+nomeConteudo+"%'  "
				+ "and disciplina.nomedisciplina like '%"+nomeDisciplina+"%'  order by disciplina.nomedisciplina, conteudo.descricao;";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARCONTEUDOSPORDESCRICAO);
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		ApoioConteudo dto;
		while(rs.next()){
			dto = new ApoioConteudo();
			putDtoApoio(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public Collection buscarConteudosPorParteDaDescricaoEDisciplina(String parteDescricao, Integer idDisciplina) throws SQLException {
//		String SQL_BUSCARCONTEUDOSPORDESCRICAO = "select * from maiorConteudo where descricao like '%"+parteDescricao+"%' and iddisciplina = ? order by descricao;";
		String SQL_BUSCARCONTEUDOSPORDESCRICAO = "select * from maiorConteudo conteudo inner join maiorDisciplina disciplina on disciplina.idDisciplina=conteudo.idDisciplina where conteudo.descricao like '%"+parteDescricao+"%' and disciplina.iddisciplina = ? order by conteudo.ordem";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARCONTEUDOSPORDESCRICAO);
		ps.setInt(1,idDisciplina.intValue());
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		ApoioConteudo dto;
		while(rs.next()){
			dto = new ApoioConteudo();
			putDtoApoio(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public Collection buscarConteudosPorDisciplina(Integer idDisciplina) throws SQLException {
		String SQL_BUSCARCONTEUDOSPORDESCRICAO = "select * from maiorConteudo conteudo inner join maiorDisciplina disciplina on disciplina.idDisciplina=conteudo.iddisciplina where conteudo.iddisciplina=? order by disciplina.nomeDisciplina, conteudo.descricao;";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARCONTEUDOSPORDESCRICAO);
		ps.setInt(1,idDisciplina.intValue());
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		ApoioConteudo dto;
		while(rs.next()){
			dto = new ApoioConteudo();
			putDtoApoio(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	public Collection buscarConteudosPorDisciplinaUsandoDTO(Integer idDisciplina) throws SQLException {
		String SQL_BUSCARCONTEUDOSPORDESCRICAO = "select * from maiorConteudo conteudo inner join maiorDisciplina disciplina on disciplina.idDisciplina=conteudo.iddisciplina where conteudo.iddisciplina=? order by conteudo.ordem";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARCONTEUDOSPORDESCRICAO);
		ps.setInt(1,idDisciplina.intValue());
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		ConteudoDTO dto;
		while(rs.next()){
			dto = new ConteudoDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
			
	public void putDto(ResultSet rs, ConteudoDTO dto) throws SQLException{
		dto.setIdConteudo(new Integer(rs.getInt("idConteudo")));
		dto.setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
		dto.setDescricao(rs.getString("descricao"));
		dto.setOrdem(new Integer(rs.getInt("ordem")));
		dto.setMonitoria(new Integer(rs.getInt("monitoria")));
		dto.setQuestoes(new Integer(rs.getInt("questoes")));
	}
	
	public void putDtoApoio(ResultSet rs, ApoioConteudo dto) throws SQLException{
		dto.setIdConteudo(rs.getString("idConteudo"));
		dto.setIdDisciplina(rs.getString("idDisciplina"));
		dto.setDescricao(rs.getString("descricao"));
		dto.setMonitoria(rs.getString("monitoria"));
		dto.setQuestoes(rs.getString("questoes"));
		dto.setOrdem(rs.getString("ordem"));
		dto.setNomeDisciplina(rs.getString("disciplina.nomeDisciplina"));
	}

	public void updateOrdemConteudo(Collection conteudos) throws SQLException {
		for (Iterator iter = conteudos.iterator(); iter.hasNext();) {
			ConteudoDTO conteudo = (ConteudoDTO) iter.next();//elemnt tem o id a ser 
			updateOrdem(conteudo);
		}
	}

	private void updateOrdem(ConteudoDTO conteudo) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERA_ORDEM);
		ps.setInt(1,conteudo.getOrdem().intValue());
		ps.setInt(2,conteudo.getIdConteudo().intValue());
		ps.executeUpdate();
		ps.close();
		
	}

	public Integer getMaiorOrdem(Integer idDisciplina) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_SETA_ULTIMA_ORDEM);
		ps.setInt(1,idDisciplina.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			return new Integer(rs.getInt("maiorOrdem"));
		else
			throw new SQLException();
	}

}
