package dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import dto.CursoDTO;

public class CursoDAO extends DAOBase{
	
    private static final String SQL_ALTERARCURSO = "update maiorCurso set nomecurso = ? where ( codigocurso = ? )";
	public static final String SQL_DELETARCURSO = "delete from maiorCurso where codigocurso = ?";
	public static final String SQL_CADASTRARCURSO = "insert into maiorCurso values (?,?)";
	public static final String SQL_LISTARTODOSCURSOS = "select * from maiorCurso order by nomecurso";
	public static final String SQL_BUSCARCURSO = "select * from maiorCurso where codigocurso = ?";
	
	public Collection listarTodosCursos() throws SQLException{
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTARTODOSCURSOS);
		Collection col = new ArrayList();
		CursoDTO dto;
		while(rs.next()){
			dto = new CursoDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public void cadastrarCurso(CursoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARCURSO);
		ps.setInt(1,0);//zero para autoincremento do Mysql
		ps.setString(2,dto.getNomeCurso());
		
		ps.executeUpdate();
		ps.close();
	}
	
	public void excluirCurso(Integer codigoCurso) throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_DELETARCURSO);
		ps.setInt(1,codigoCurso.intValue());
		ps.executeUpdate();
		ps.close();

		
	}
	
	public CursoDTO buscarCurso(Integer codigoCurso) throws SQLException {
		CursoDTO dto = new CursoDTO();

		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARCURSO);
		ps.setInt(1,codigoCurso.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDto(rs,dto);
		rs.close();
		ps.close();
		return dto;
		
	}
	
	public void alterarCurso(CursoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARCURSO);
		ps.setString(1,dto.getNomeCurso());
		ps.setInt(2,dto.getCodigoCurso().intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public Collection buscarCursosPorParteDoNome(String parametroBusca) throws SQLException {
		String SQL_BUSCARCURSOSPORNOME = "select * from maiorCurso where nomecurso like '%"+parametroBusca+"%' order by nomecurso;";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARCURSOSPORNOME);
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		CursoDTO dto;
		while(rs.next()){
			dto = new CursoDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public void putDto(ResultSet rs, CursoDTO dto) throws SQLException{
		dto.setCodigoCurso(new Integer(rs.getInt("codigoCurso")));
		dto.setNomeCurso(rs.getString("nomeCurso"));
	}

}
