/*
 * Created on 11/07/2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package dao;

import java.sql.*;

import slave.ConectionPool;
import DominioDiaDaSemana.Dominio;
import dto.LoginDTO;

// um Factory e um Singleton
public class DAOFactory {

	private String DRIVER_CLASS;
	private String URL;
	private String USER_NAME;
	private String PASSWORD;
	private static DAOFactory daoFactory = null;
	
	private DAOFactory() {}
	
	public static DAOFactory getInstance() {
		if( daoFactory == null ) {
			daoFactory = new DAOFactory();
		}
		return daoFactory;
	}
	
	public IDAO getDAO( String daoClassName, LoginDTO loginLogado) 
		throws	ClassNotFoundException,//se nao conseguir achar a classe.
				IllegalAccessException,//nao conseguir acessar um mtodo da classe.
				SQLException,
				InstantiationException //se nao conseguir instanciar um objeto da classe.
	{
		
		//Instncia dinmica de uma classe.
		Class daoClass = Class.forName( daoClassName );
		IDAO result = (IDAO) daoClass.newInstance();
		result.setConnection( getConnection(loginLogado) );
		result.setLoginUsuarioDTOLogado(loginLogado);
		
		return result;
	}
	
	private Connection getConnection(LoginDTO login) throws ClassNotFoundException, SQLException {
		Connection result = null;
		getPropierties(login);
		Class.forName(DRIVER_CLASS);
		result = DriverManager.getConnection(URL,USER_NAME, PASSWORD);
		return result;
	}
	private void getPropierties(LoginDTO login){
		setDRIVER_CLASS(ConectionPool.getInstance().obter("DRIVER_CLASS"));
		setURL(ConectionPool.getInstance().obter("URL"));
		
		if(login==null || login.getPerfil()==null){
			setPASSWORD(ConectionPool.getInstance().obter("VISITANTE_PASSWORD"));
			setUSER_NAME(ConectionPool.getInstance().obter("VISITANTE_USER_NAME"));
		}else if(login.getPerfil().intValue()==Dominio.getAdministrador().intValue()){
			setPASSWORD(ConectionPool.getInstance().obter("ADMIN_PASSWORD"));
			setUSER_NAME(ConectionPool.getInstance().obter("ADMIN_USER_NAME"));
		}else if(login.getPerfil().intValue()==Dominio.getDiretor().intValue()){
			setPASSWORD(ConectionPool.getInstance().obter("DIRETOR_PASSWORD"));
			setUSER_NAME(ConectionPool.getInstance().obter("DIRETOR_USER_NAME"));
		}else if(login.getPerfil().intValue()==Dominio.getProfessor().intValue()){
			setPASSWORD(ConectionPool.getInstance().obter("PROFESSOR_PASSWORD"));
			setUSER_NAME(ConectionPool.getInstance().obter("PROFESSOR_USER_NAME"));
		}else if(login.getPerfil().intValue()==Dominio.getMonitor().intValue()){
			setPASSWORD(ConectionPool.getInstance().obter("MONITOR_PASSWORD"));
			setUSER_NAME(ConectionPool.getInstance().obter("MONITOR_USER_NAME"));
		}else{
			setPASSWORD(ConectionPool.getInstance().obter("ALUNO_PASSWORD"));
			setUSER_NAME(ConectionPool.getInstance().obter("ALUNO_USER_NAME"));
		}
	}
	
	public String getDRIVER_CLASS() {
		return DRIVER_CLASS;
	}

	public void setDRIVER_CLASS(String driver_class) {
		DRIVER_CLASS = driver_class;
	}

	public String getPASSWORD() {
		return PASSWORD;
	}

	public void setPASSWORD(String password) {
		PASSWORD = password;
	}

	public String getURL() {
		return URL;
	}

	public void setURL(String url) {
		URL = url;
	}

	public String getUSER_NAME() {
		return USER_NAME;
	}

	public void setUSER_NAME(String user_name) {
		USER_NAME = user_name;
	}
	
}
