package dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import dto.DiretorDTO;

public class DiretorDAO extends DAOBase{

	
	public static String SQL_CADASTRARDIRETOR = "INSERT INTO maiorDiretor VALUES(?,?,?,?,?,?)";
	public static String SQL_ALTERADIRETOR = "UPDATE maiorDiretor SET dtRegistro = ?, codigoCurso = ?, maiorTitulo = ?, situacao =  ?, matriculaFuncional = ? WHERE (chavePessoa = ?)";
	public static final String SQL_BUSCADIRETOR = "SELECT A.chavePessoa, A.nomePessoa,A.apelido, A.dtNascer, A.cpf, A.sexo, B.situacao, A.email, A.webPessoal,B.dtRegistro, B.codigoCurso, B.matriculaFuncional, B.maiorTitulo FROM maiorPessoa A, maiorDiretor B WHERE A.chavePessoa = ? AND A.chavePessoa = B.chavePessoa ORDER BY A.nomePessoa ";
	public static final String SQL_EXCLUIRDIRETOR = "DELETE FROM maiorDiretor WHERE chavePessoa = ?";
	public void alterarDiretor(DiretorDTO dto) throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERADIRETOR);
		ps.setDate(1,dto.getDtRegistro());
		ps.setInt(2,dto.getCodigoCurso().intValue());
		ps.setString(3,dto.getMaiorTitulo());
		ps.setString(4,dto.getSituacao());
		ps.setString(5,dto.getMatriculaFuncional());
		ps.setInt(6,dto.getChavePessoa().intValue());
		ps.executeUpdate();
		ps.close();
	}
	public Collection buscarDiretorPorNome(String nomeDiretor) throws SQLException{
		String SQL_BUSCARALUNOPORNOME = "SELECT A.chavePessoa, A.nomePessoa, A.apelido, A.dtNascer, A.cpf, A.sexo, B.situacao, A.email, " +
		"A.webPessoal,B.dtRegistro, B.codigoCurso, B.matriculaFuncional,B.maiorTitulo FROM maiorPessoa A, maiorDiretor B WHERE A.nomePessoa " +
		"LIKE '%"+nomeDiretor+"%' AND A.chavePessoa = B.chavePessoa ORDER BY A.nomePessoa ";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARALUNOPORNOME);
		DiretorDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new DiretorDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		return col;
	}
	
	public DiretorDTO buscarDiretor(Integer chavePessoa) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCADIRETOR);
		ps.setInt(1,chavePessoa.intValue());
		ResultSet rs = ps.executeQuery();
		DiretorDTO dto = new DiretorDTO();
		if(rs.next())
			putDto(rs,dto);
		return dto;
	}
	public void excluirDiretor(Integer chavePessoa) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_EXCLUIRDIRETOR);
		ps.setInt(1,chavePessoa.intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public void cadastrarDiretor(DiretorDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARDIRETOR);
		
		ps.setInt(1,dto.getChavePessoa().intValue());
		ps.setDate(2,dto.getDtRegistro());
		ps.setInt(3,dto.getCodigoCurso().intValue());
		ps.setString(4,dto.getMaiorTitulo());
		ps.setString(5,dto.getSituacao());
		ps.setString(6,dto.getMatriculaFuncional());

		ps.executeUpdate();
		ps.close();
		
	}
	
	private void putDto(ResultSet rs, DiretorDTO dto) throws SQLException{
		dto.setChavePessoa(new Integer(rs.getInt("chavePessoa")));
		dto.setNomePessoa(rs.getString("nomePessoa"));
		dto.setDtNascer(rs.getDate("dtNascer"));
		dto.setCpf(rs.getString("cpf"));
		dto.setSexo(rs.getString("sexo"));
		dto.setApelido(rs.getString("apelido"));
		dto.setSituacao(rs.getString("situacao"));//pegando situacao de Diretor nao de pessoa
		dto.setWebPessoal(rs.getString("webPessoal"));
		dto.setEmail(rs.getString("email"));
		
		dto.setDtRegistro(rs.getDate("dtRegistro"));
		dto.setCodigoCurso(new Integer(rs.getInt("codigoCurso")));
		dto.setMatriculaFuncional(rs.getString("matriculaFuncional"));
		dto.setMaiorTitulo(rs.getString("maiorTitulo"));
	}
	public Collection buscarDiretorPorMatricula(String matriculaFuncional) throws SQLException {
		String SQL_BUSCARALUNOPORMATRICULA = "SELECT A.chavePessoa, A.nomePessoa,A.apelido, A.dtNascer, A.cpf, A.sexo, B.situacao, A.email, " +
		"A.webPessoal,B.dtRegistro, B.codigoCurso, B.matriculaFuncional,B.maiorTitulo FROM maiorPessoa A, maiorDiretor B WHERE B.matriculaFuncional " +
		"= '"+matriculaFuncional+"' AND A.chavePessoa = B.chavePessoa ORDER BY A.nomePessoa ";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARALUNOPORMATRICULA);
		DiretorDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new DiretorDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		return col;
	}
	public Collection buscarDiretorPorNomeMatricula(String nomeDiretor,String matriculaFuncional) throws SQLException {
		String SQL_BUSCARALUNOPORNOMEMATRICULA = "SELECT A.chavePessoa, A.nomePessoa,A.apelido, A.dtNascer, A.cpf, A.sexo, B.situacao, A.email, " +
		"A.webPessoal,B.dtRegistro, B.codigoCurso, B.matriculaFuncional,B.maiorTitulo FROM maiorPessoa A, maiorDiretor B WHERE B.matriculaFuncional " +
		"= '"+matriculaFuncional+"' AND A.nomePessoa LIKE '%"+nomeDiretor+"%' AND A.chavePessoa = B.chavePessoa ORDER BY A.nomePessoa ";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARALUNOPORNOMEMATRICULA);
		DiretorDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new DiretorDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		return col;
	}
	public void alterarDadosCadastrais(DiretorDTO dto) throws SQLException {
		String SQL_ALTERADADOSCADASTRAISDIRETOR = "UPDATE  maiorPessoa p, maiorDiretor dir SET dir.codigoCurso = ?, dir.maiorTitulo = ?," +
		" p.apelido = ?,p.email = ?,p.webPessoal = ? " +
		"WHERE (p.chavePessoa = ? AND dir.chavePessoa = ?)";
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERADADOSCADASTRAISDIRETOR);
		ps.setInt(1,dto.getCodigoCurso().intValue());
		ps.setString(2,dto.getMaiorTitulo());
		ps.setString(3,dto.getApelido());
		ps.setString(4,dto.getEmail());
		ps.setString(5,dto.getWebPessoal());
		ps.setInt(6,dto.getChavePessoa().intValue());
		ps.setInt(7,dto.getChavePessoa().intValue());
		ps.executeUpdate();
		ps.close();
		
	}
}
