package dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import DominioDiaDaSemana.Dominio;
import dto.DisciplinaDTO;

public class DisciplinaDAO extends DAOBase {

	private static final String SQL_ALTERARDISCIPLINA = "update maiorDisciplina set nomedisciplina = ?, objetivo = ?, cargahoraria = ?, nivelMedio = ? where ( iddisciplina = ? )";
	private static final String SQL_DELETARDISCIPLINA = "delete from maiorDisciplina where iddisciplina = ?";
	private static final String SQL_CADASTRARDISCIPLINA = "insert into maiorDisciplina values (?,?,?,?,?)";
	private static final String SQL_LISTARTODOSDISCIPLINA = "select * from maiorDisciplina order by nomedisciplina";
	private static final String SQL_BUSCARDISCIPLINA = "select * from maiorDisciplina where iddisciplina = ?";

	public Collection listarTodasDisciplinas() throws SQLException {
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTARTODOSDISCIPLINA);
		Collection col = new ArrayList();
		DisciplinaDTO dto;
		while (rs.next()) {
			dto = new DisciplinaDTO();
			putDto(rs, dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}

	public void cadastrarDisciplina(DisciplinaDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARDISCIPLINA);
		ps.setInt(1, 0);//zero para autoincremento do Mysql
		ps.setString(2, dto.getNomeDisciplina());
		ps.setString(3, dto.getObjetivo());
		ps.setInt(4, dto.getCargaHoraria().intValue());
		ps.setInt(5,dto.getNivel().intValue());
		ps.executeUpdate();
		ps.close();
	}

	public void excluirDisciplina(Integer idDiciplina) throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_DELETARDISCIPLINA);
//		System.out.println(SQL_DELETARDISCIPLINA);
//		System.out.println(idDiciplina);
		ps.setInt(1, idDiciplina.intValue());
		ps.executeUpdate();
		ps.close();

	}

	public DisciplinaDTO buscarDisciplina(Integer idDisciplina) throws SQLException {
		DisciplinaDTO dto = new DisciplinaDTO();

		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARDISCIPLINA);
		ps.setInt(1, idDisciplina.intValue());
		ResultSet rs = ps.executeQuery();
		if (rs.next())
			putDto(rs, dto);
		rs.close();
		ps.close();
		return dto;

	}

	public void alterarDisciplina(DisciplinaDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARDISCIPLINA);
		ps.setString(1, dto.getNomeDisciplina());
		ps.setString(2, dto.getObjetivo());
		ps.setInt(3, dto.getCargaHoraria().intValue());
		ps.setInt(5, dto.getIdDisciplina().intValue());
		ps.setInt(4,dto.getNivel().intValue());
		ps.executeUpdate();
//		System.out.println(SQL_ALTERARDISCIPLINA);
//		System.out.println(dto.getNivel());
		ps.close();
	}

	public Collection buscarDisciplinasPorParteDoNomeECurso(String nomeDisciplina, String nomeCurso)
			throws SQLException {
		String select = montaSelectDisciplinaPorNomeECurso(nomeDisciplina, nomeCurso);
		PreparedStatement ps = getConnection().prepareStatement(select);
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		DisciplinaDTO dto;
		while (rs.next()) {
			dto = new DisciplinaDTO();
			putDto(rs, dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	private String montaSelectDisciplinaPorNomeECurso(String nomeDisciplina, String nomeCurso) {
		StringBuffer select = new StringBuffer();
			select.append("select * from maiorDisciplina disc ");
			select.append("left join maiorCurso_Disciplina rel on disc.iddisciplina=rel.iddisciplina ");
			select.append("left join maiorCurso curso on rel.codigocurso=curso.codigocurso ");
			
			if(getLoginUsuarioDTOLogado().getPerfil().intValue()==Dominio.getAluno().intValue())
				select.append("inner join maiorAluno aluno on aluno.codigocurso=curso.codigocurso ");
			else if(getLoginUsuarioDTOLogado().getPerfil().intValue()==Dominio.getMonitor().intValue())
				select.append("inner join maiorMonitor monitor on monitor.idDisciplina=disc.idDisciplina ");
			else if(getLoginUsuarioDTOLogado().getPerfil().intValue()==Dominio.getProfessor().intValue())
				select.append("inner join maiorProfessor professor on professor.codigoCursoVinculo=curso.codigocurso ");
			else if(getLoginUsuarioDTOLogado().getPerfil().intValue()==Dominio.getDiretor().intValue())
				select.append("inner join maiorDiretor diretor on diretor.codigoCurso=curso.codigocurso ");
				
			select.append("where disc.nomedisciplina like '%" + nomeDisciplina + "%' ");
			if(nomeCurso!=null && !nomeCurso.equals(""))
				select.append("and curso.nomecurso like '%" + nomeCurso + "%' ");
			
			if(getLoginUsuarioDTOLogado().getPerfil().intValue()==Dominio.getAluno().intValue())
				select.append("and aluno.chavePessoa="+getLoginUsuarioDTOLogado().getChavePessoa()+" ");
			else if(getLoginUsuarioDTOLogado().getPerfil().intValue()==Dominio.getMonitor().intValue())
				select.append("and monitor.chavePessoa="+getLoginUsuarioDTOLogado().getChavePessoa()+" ");
			else if(getLoginUsuarioDTOLogado().getPerfil().intValue()==Dominio.getProfessor().intValue())
				select.append("and professor.chavePessoa="+getLoginUsuarioDTOLogado().getChavePessoa()+" ");
			else if(getLoginUsuarioDTOLogado().getPerfil().intValue()==Dominio.getDiretor().intValue())
				select.append("and diretor.chavePessoa="+getLoginUsuarioDTOLogado().getChavePessoa()+" ");
			
			select.append("group by disc.idDisciplina order by disc.nomedisciplina ");
		return select.toString();
	}

	public Collection buscarDisciplinasPorParteDoNomeECursoEMonitor(String nomeDisciplina, String nomeCurso, Integer chaveMonitor)
			throws SQLException {
		//		String SQL_BUSCARCURSOSPORNOME = "SELECT * FROM maiorDisciplina WHERE NOMEDISCIPLINA LIKE
		// '%"+nomeDisciplina+"%' ORDER BY NOMEDISCIPLINA;";
		String SQL_BUSCARDISCIPLINASPORNOMEECURSO = "select * from maiorDisciplina disc "
				+ "inner join maiorCurso_Disciplina rel on disc.iddisciplina=rel.iddisciplina "
				+ "inner join maiorCurso curso on rel.codigocurso=curso.codigocurso "
				+ "inner join maiorMonitor monitor on monitor.idDisciplina=disc.iddisciplina "
				+ "where disc.nomedisciplina like '%" + nomeDisciplina + "%' "
				+ "and curso.nomecurso like '%" + nomeCurso + "%' and monitor.chavePessoa="+chaveMonitor.intValue()+" " 
				+ "order by disc.nomedisciplina";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARDISCIPLINASPORNOMEECURSO);
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		DisciplinaDTO dto;
		while (rs.next()) {
			dto = new DisciplinaDTO();
			putDto(rs, dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}

	public void putDto(ResultSet rs, DisciplinaDTO dto) throws SQLException {
		dto.setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
		dto.setNomeDisciplina(rs.getString("nomeDisciplina"));
		dto.setObjetivo(rs.getString("objetivo"));
		dto.setCargaHoraria(new Integer(rs.getString("cargaHoraria")));
		dto.setNivel(new Integer(rs.getInt("nivelMedio")));
	}

	public Integer buscarIdUltimaDisciplinaCadastrada() throws SQLException {
		String SQL_BUSCARMAIORIDDISCIPLINA = "select max(iddisciplina) from maiorDisciplina";
		Integer idDisciplina = null;
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARMAIORIDDISCIPLINA);
		ResultSet rs = ps.executeQuery();
		if (rs.next())
			idDisciplina = new Integer(rs.getInt(1));
		rs.close();
		ps.close();
		return idDisciplina;
	}

	public Collection buscarDisciplinasPorParteDoNomeECodigoDoCurso(String nomeDisciplina,
			Integer codigoCurso) throws SQLException {
		String SQL_BUSCARDISCIPLINASPORNOMEECURSO = "select * from maiorDisciplina disc "
				+ "inner join maiorCurso_Disciplina rel on disc.iddisciplina=rel.iddisciplina "
				+ "inner join maiorCurso curso on rel.codigocurso=curso.codigocurso "
				+ "where disc.nomedisciplina like '%" + nomeDisciplina + "%' "
				+ "and curso.codigocurso= ? order by disc.nomedisciplina";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARDISCIPLINASPORNOMEECURSO);
		ps.setInt(1, codigoCurso.intValue());
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		DisciplinaDTO dto;
		while (rs.next()) {
			dto = new DisciplinaDTO();
			putDto(rs, dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}

}