package dao;

import java.sql.*;

import dto.LoginDTO;

public class LoginDAO extends DAOBase {
	private static String chaveCript = "SAE2007UCB";

	//public static final String SQL_VERIFICARLOGIN = "SELECT * FROM maiorAcesso WHERE login = ? AND senha = ?;";
	
	public LoginDTO verificarLogin(LoginDTO dto) throws SQLException {
		//SQL PARA BUSCA DE LOGIN PREPAREDSTATEMENT NAO BUSCA TABELA
//		String SQL_VERIFICARLOGIN = "SELECT * FROM maiorAcesso, "+getTable(dto.getPerfil())+" WHERE maiorAcesso.login = '"+
//		dto.getLogin()+"' AND maiorAcesso.senha = '"+dto.getSenha()+"' AND maiorAcesso.chavePessoa = "
//		+getTable(dto.getPerfil())+".chavePessoa";
		
		//FIZ ISSO PARA O CONTROLE DE ENTRADAS QUE TENTEM FRANDAR A SEGURANA COMO A STRING "  ' or 1=1 --  "
//		String SQL_VERIFICARLOGIN = "SELECT * FROM maiorAcesso, "+getTable(dto.getPerfil())+" WHERE maiorAcesso.login = ? AND decode(maiorAcesso.senha,'"+chaveCript+"') = ? AND maiorAcesso.chavePessoa = "
//		+getTable(dto.getPerfil())+".chavePessoa";
		
		String SQL_VERIFICARLOGIN;
		switch (dto.getPerfil().intValue()) {
		case 1:{//para administrador
			 SQL_VERIFICARLOGIN = "SELECT * FROM maiorPessoa p,maiorAcesso, "+getTable(dto.getPerfil())+" perfil" +
			 		" WHERE maiorAcesso.login = ?" +
			 		" AND maiorAcesso.senha = ?" +
			 		" AND maiorAcesso.chavePessoa = perfil.chavePessoa" +
			 		" AND p.situacao = 'A'";
			break;
		}
		case 5:{ // para monitores
			 SQL_VERIFICARLOGIN = "SELECT * FROM maiorPessoa p,maiorAcesso, "+getTable(dto.getPerfil())+" perfil " +
			 		" WHERE maiorAcesso.login = ?" +
			 		" AND maiorAcesso.senha = ?" +
			 		" AND maiorAcesso.chavePessoa = perfil.chavePessoa" +
					" AND p.situacao = 'A'" +
					" AND perfil.dtSaida is NULL ";
			break;
		}

		default:{ // para os perfis aluno, professor, diretor
			 SQL_VERIFICARLOGIN = "SELECT * FROM maiorPessoa p,maiorAcesso, "+getTable(dto.getPerfil())+" perfil " +
			 		" WHERE maiorAcesso.login = ? " +
			 		" AND maiorAcesso.senha = ? " +
			 		" AND maiorAcesso.chavePessoa = perfil.chavePessoa " +
					" AND p.situacao = 'A'" +
					" AND perfil.situacao = 'A'";

			break;
		}
		}
		
		
		PreparedStatement ps = getConnection().prepareStatement(SQL_VERIFICARLOGIN);
		ps.setString(1, dto.getLogin());
		ps.setString(2, dto.getSenha());
		
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			if(dto.getSenha().equals(rs.getString("senha"))){ // para garantir que no vai aceitar a mesma senha em MAISCULO E MINSCULO
				dto.setChavePessoa(new Integer(rs.getInt("perfil.chavePessoa")));
			}else{
				dto.setChavePessoa(null);
			}
		
		ps.close();
		return dto;
	}
	public void alterarLogin(LoginDTO dto) throws SQLException {
//		String SQL_ALTERARLOGIN = "UPDATE maiorAcesso set senha = encode(?,'"+chaveCript+"') WHERE ( chavePessoa = ? )";
		String SQL_ALTERARLOGIN = "UPDATE maiorAcesso set senha = ? WHERE ( chavePessoa = ? )";
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARLOGIN);
		ps.setString(1,dto.getSenha());
		ps.setInt(2,dto.getChavePessoa().intValue());
		ps.executeUpdate();
		ps.close();
		
	}
	public void cadastrarLogin(LoginDTO dto) throws SQLException {
//		String SQL_ALTERARLOGIN = "UPDATE maiorAcesso set senha = encode(?,'"+chaveCript+"') WHERE ( chavePessoa = ? )";
		String SQL_ALTERARLOGIN = "insert into maiorAcesso values(?,?,?)";
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARLOGIN);
		ps.setInt(1,dto.getChavePessoa().intValue());
		ps.setString(2,dto.getLogin());
		ps.setString(3,dto.getSenha());
		ps.executeUpdate();
		ps.close();
		
	}
	public LoginDTO buscaLogin(Integer chavePessoa) throws SQLException {
		String SQL_BUSCARLOGIN = "select * from maiorAcesso WHERE ( chavePessoa = ? )";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARLOGIN);
		ps.setInt(1,chavePessoa.intValue());
		ResultSet rs = ps.executeQuery();
		LoginDTO login = new LoginDTO();
		if(rs.next()){
			login.setChavePessoa(chavePessoa);
			login.setLogin(rs.getString("login"));
		}
		ps.close();
		return login;
	}
	public LoginDTO buscarLoginPeloLogin(String loginTemp) throws SQLException {
		String SQL_BUSCARLOGIN = "select * from maiorAcesso WHERE ( login = ? )";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARLOGIN);
		ps.setString(1,loginTemp);
		ResultSet rs = ps.executeQuery();
		LoginDTO login = new LoginDTO();
		if(rs.next()){
			login.setChavePessoa(new Integer(rs.getString("chavePessoa")));
			login.setLogin(rs.getString("login"));
			login.setSenha(rs.getString("senha"));
		}
		ps.close();
		return login;
	}
	
	public String getTable(Integer perfil){
		if(perfil.intValue() == 1)
			return "maiorAdministrador";
		else if(perfil.intValue()== 2)
			return "maiorAluno";
		else if(perfil.intValue()== 3)
			return "maiorProfessor"; 
		else if(perfil.intValue()==4)
			return "maiorDiretor"; 
		else if(perfil.intValue()== 5)
			return "maiorMonitor"; 
		return null;
	}
	
	public LoginDTO getLoginByMail(String mail) throws SQLException {
		String SQL_GETLOGINBYMAIL = "SELECT a.* FROM maiorAcesso a, maiorPessoa b WHERE a.chavePessoa = b.chavePessoa AND b.email = ? ";
		PreparedStatement ps = getConnection().prepareStatement(SQL_GETLOGINBYMAIL);
		ps.setString(1,mail);
		ResultSet rs = ps.executeQuery();
		LoginDTO login = new LoginDTO();
		if(rs.next()){
			login.setChavePessoa(Integer.parseInt(rs.getString("chavepessoa")));
			login.setLogin(rs.getString("login"));
			login.setSenha(rs.getString("senha"));
		}
		ps.close();
		return login;
	}
}
