package dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import dto.MonitorDTO;

public class MonitorDAO extends DAOBase{
	public static final String SQL_CADASTRARMONITOR = "INSERT INTO maiorMonitor VALUES(?,?,?,?,?,?);";
	
	public static final String SQL_BUSCAMONITOR = "SELECT A.chavePessoa, A.nomePessoa,A.apelido, A.dtNascer, A.cpf, A.sexo, A.situacao, " +
	"A.email,A.webPessoal,B.idDisciplina,B.ano,B.semestre,B.dtRegistro, " +
	"B.dtSaida FROM maiorPessoa A, maiorMonitor B WHERE B.chavePessoa = ? AND A.chavePessoa = B.chavePessoa ORDER BY A.nomePessoa ";
	
	public static final String SQL_BUSCAMONITOREMSEMESTREESPECIFICO = "SELECT A.chavePessoa, A.nomePessoa,A.apelido, A.dtNascer, A.cpf, A.sexo, A.situacao, " +
	"A.email,A.webPessoal,B.idDisciplina,B.ano,B.semestre,B.dtRegistro, " +
	"B.dtSaida FROM maiorPessoa A, maiorMonitor B WHERE B.chavePessoa = ? AND A.chavePessoa = B.chavePessoa AND B.idDisciplina = ? AND B.ano=? AND B.semestre = ? ORDER BY A.nomePessoa ";
	
	public static final String SQL_BUSCA_DISCIPLINAS_COM_MONITORIAS_ATIVAS_POR_MONITOR = "SELECT A.chavePessoa, A.nomePessoa,B.idDisciplina,B.ano,B.semestre " +
			" FROM maiorPessoa A, maiorMonitor B " +
			" WHERE B.chavePessoa = ? AND A.chavePessoa = B.chavePessoa and dtSAida is null";
		
	public static final String SQL_EXCLUIRMONITOR = "DELETE FROM maiorMonitor WHERE chavePessoa = ? AND idDisciplina= ? AND semestre = ? AND ano= ?";
	
	public static final String SQL_ALTERARMONITOR = "UPDATE maiorMonitor SET dtRegistro = ?, dtSaida = ?, idDisciplina = ?, ano =  ?, semestre = ? WHERE (chavePessoa = ?)";

	private static final String SQL_ALTERARMONITORSEMESTRE = "UPDATE maiorMonitor SET dtRegistro = ?, dtSaida = ?, idDisciplina = ?, ano =  ?, semestre = ? WHERE chavePessoa = ?"+
															" AND idDisciplina= ? AND semestre = ? AND ano= ?";
	
	public Collection buscarMonitorPorNome(String nomeMonitor) throws SQLException {
		String SQL_BUSCAMONITORPORNOME = "SELECT A.chavePessoa, A.nomePessoa,A.apelido, A.dtNascer, A.cpf, A.sexo, A.situacao, " +
				"A.email,A.webPessoal,B.idDisciplina,B.ano,B.semestre,B.dtRegistro, " +
				"B.dtSaida FROM maiorPessoa A, maiorMonitor B WHERE A.nomePessoa " +
				"LIKE '%"+nomeMonitor+"%' AND A.chavePessoa = B.chavePessoa ORDER BY A.nomePessoa ";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCAMONITORPORNOME);
		MonitorDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new MonitorDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		return col;
	}
	public Collection buscarMonitorPorNomeDiscplina(String nomeMonitor, String disciplina) throws SQLException {
		String SQL_BUSCARMONITORPORNOMEDISCIPLINA = "SELECT A.chavePessoa, A.nomePessoa,A.apelido, A.dtNascer, A.cpf, A.sexo, A.situacao,"+
		"A.email,A.webPessoal,B.idDisciplina,B.ano,B.semestre,B.dtRegistro,"+
		"B.dtSaida FROM maiorPessoa A, maiorMonitor B, maiorDisciplina C"+
	  " WHERE A.chavePessoa = B.chavePessoa AND C.idDisciplina = B.idDisciplina AND C.nomeDisciplina LIKE '%"+disciplina+"%' AND A.nomePessoa LIKE '%"+nomeMonitor+"%' ORDER BY A.nomePessoa ";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARMONITORPORNOMEDISCIPLINA);
		MonitorDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new MonitorDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		return col;
	}
	public void cadastrarMonitor(MonitorDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARMONITOR);
		ps.setInt(1,dto.getChavePessoa().intValue());
		ps.setInt(2,dto.getIdDisciplina().intValue());
		ps.setInt(3,dto.getAno().intValue());
		ps.setString(4,dto.getSemestre().toString());//sujeito a alteracoes
		ps.setDate(5,dto.getDtRegistro());
		ps.setDate(6,dto.getDtSaida());
		ps.executeUpdate();	
		ps.close();
	}
	
	public MonitorDTO buscarMonitor(Integer chavePessoa) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAMONITOR);
		ps.setInt(1,chavePessoa.intValue());
		ResultSet rs = ps.executeQuery();
		MonitorDTO dto = new MonitorDTO();
		if(rs.next())
			putDto(rs,dto);
		return dto;
		
	}
	public MonitorDTO buscarMonitorEmSemestreEspecifico(Integer chavePessoa,Integer idDisciplina, Integer ano, String semestre) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAMONITOREMSEMESTREESPECIFICO);
		ps.setInt(1,chavePessoa);
		ps.setInt(2,idDisciplina);
		ps.setInt(3,ano);
		ps.setString(4,semestre);
		ResultSet rs = ps.executeQuery();
		MonitorDTO dto = new MonitorDTO();
		if(rs.next())
			putDto(rs,dto);
		return dto;
		
	}
	public Collection buscarDisciplinasComMonitoriasAtivasPorMonitor(Integer chavePessoa) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCA_DISCIPLINAS_COM_MONITORIAS_ATIVAS_POR_MONITOR);
		ps.setInt(1,chavePessoa);
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		MonitorDTO dto;
		while(rs.next()){
			dto = new MonitorDTO();
			put2Dto(rs,dto);
			col.add(dto);
		}
		return col;
		
	}
	public Collection buscarMonitorPorDisciplina(String disciplina) throws SQLException{
		String SQL_BUSCARMONITORPORDISCIPLINA = "SELECT A.chavePessoa, A.nomePessoa,A.apelido, A.dtNascer, A.cpf, A.sexo, A.situacao,"+
		"A.email,A.webPessoal,B.idDisciplina,B.ano,B.semestre,B.dtRegistro,"+
		"B.dtSaida FROM maiorPessoa A, maiorMonitor B, maiorDisciplina C"+
	  " WHERE A.chavePessoa = B.chavePessoa AND C.idDisciplina = B.idDisciplina AND C.nomeDisciplina LIKE '%"+disciplina+"%' ORDER BY A.nomePessoa ";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARMONITORPORDISCIPLINA);
		MonitorDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new MonitorDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		return col;
	}
	
	public void excluir(Integer chavePessoa, int disciplina, int ano, String semestre) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_EXCLUIRMONITOR);
		ps.setInt(1,chavePessoa.intValue());
		ps.setInt(2, disciplina);
		ps.setString(3, semestre);
		ps.setInt(4, ano);
		ps.executeUpdate();
		ps.close();
		
	}
	
	public void alterarMonitor(MonitorDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARMONITOR);
		ps.setDate(1,dto.getDtRegistro());
		ps.setDate(2,dto.getDtSaida());
		ps.setInt(3,dto.getIdDisciplina().intValue());
		ps.setInt(4,dto.getAno().intValue());
		ps.setString(5,dto.getSemestre().toString());
		ps.setInt(6,dto.getChavePessoa().intValue());
		ps.executeUpdate();
		ps.close();
	}

	
	private void putDto(ResultSet rs, MonitorDTO dto) throws SQLException{
		dto.setChavePessoa(new Integer(rs.getInt("chavePessoa")));
		dto.setNomePessoa(rs.getString("nomePessoa"));
		dto.setDtNascer(rs.getDate("dtNascer"));
		dto.setCpf(rs.getString("cpf"));
		dto.setApelido(rs.getString("apelido"));
		dto.setSexo(rs.getString("sexo"));
		dto.setSituacao(rs.getString("situacao"));
		dto.setWebPessoal(rs.getString("webPessoal"));
		dto.setEmail(rs.getString("email"));
		//monitor
		dto.setDtRegistro(rs.getDate("dtRegistro"));
		dto.setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
		dto.setAno(new Integer(rs.getInt("ano")));
		dto.setSemestre(new Integer(rs.getString("semestre")));//sujeito a alteracoes
		dto.setDtSaida(rs.getDate("dtSaida"));
	}
	
	private void put2Dto(ResultSet rs, MonitorDTO dto) throws SQLException{
		dto.setChavePessoa(new Integer(rs.getInt("chavePessoa")));
		dto.setNomePessoa(rs.getString("nomePessoa"));
		dto.setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
		dto.setAno(new Integer(rs.getInt("ano")));
		dto.setSemestre(new Integer(rs.getString("semestre")));//sujeito a alteracoes
	}
	public void alterarMonitorSemestre(MonitorDTO dto, int chavePessoa, int disciplina, int ano, String semestre) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARMONITORSEMESTRE);
		ps.setDate(1,dto.getDtRegistro());
		ps.setDate(2,dto.getDtSaida());
		ps.setInt(3,dto.getIdDisciplina().intValue());
		ps.setInt(4,dto.getAno().intValue());
		ps.setString(5,dto.getSemestre().toString());
		ps.setInt(6,dto.getChavePessoa().intValue());
		ps.setInt(7,disciplina);
		ps.setString(8,semestre);
		ps.setInt(9,ano);
		ps.executeUpdate();
		ps.close();
		
	}








}
