package dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import dto.PessoaDTO;

public class PessoaDAO extends DAOBase{
	
	private static final String SQL_BUSCAULTIMOINSERIDO = "SELECT MAX(chavePessoa) as chavePessoa FROM maiorPessoa";
    private static final String SQL_ALTERARPESSOA = "UPDATE maiorPessoa SET nomePessoa = ?, "
        + "dtNascer = ?, sexo = ?, situacao = ?, email = ?, "
        + "webPessoal = ?, cpf = ?, apelido = ? WHERE ( chavePessoa = ? )";
	public static final String SQL_DELETARPESSOA = "DELETE FROM maiorPessoa WHERE chavePessoa = ?";
	public static final String SQL_CADASTRARPESSOA = "INSERT INTO maiorPessoa VALUES (?,?,?,?,?,?,?,?,?)";
	public static final String SQL_LISTARTODASPESSOAS = "SELECT * FROM maiorPessoa ORDER BY nomePessoa";
	public static final String SQL_LISTARTODASPESSOAS_ATIVAS = "SELECT * FROM maiorPessoa WHERE situacao = 'A' ORDER BY nomePessoa";
	public static final String SQL_BUSCARPESSOA = "SELECT * FROM maiorPessoa WHERE chavePessoa = ?";
	public Collection listarTodasPessoas() throws SQLException{
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTARTODASPESSOAS);
		Collection col = new ArrayList();
		PessoaDTO dto;
		while(rs.next()){
			dto = new PessoaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	public void cadastrarPessoa(PessoaDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARPESSOA);
		ps.setInt(1,0);//zero para autoincremento do Mysql
		ps.setString(2,dto.getNomePessoa());
		ps.setDate(3,dto.getDtNascer());
		ps.setString(4,dto.getCpf());
		ps.setString(5,dto.getSexo());
		ps.setString(6,dto.getEmail());
		ps.setString(7,dto.getSituacao());
		ps.setString(8,dto.getApelido());
		ps.setString(9,dto.getWebPessoal());
		
		ps.executeUpdate();
		ps.close();
	}
	public void excluirPessoa(Integer chavePessoa) throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_DELETARPESSOA);
		ps.setInt(1,chavePessoa.intValue());
		ps.executeUpdate();
		ps.close();

		
	}
	public PessoaDTO buscarPessoa(Integer chavePessoa) throws SQLException {
		PessoaDTO dto = new PessoaDTO();

		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARPESSOA);
		ps.setInt(1,chavePessoa.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDto(rs,dto);
		rs.close();
		ps.close();
		return dto;
		
	}
	public void alterarPessoa(PessoaDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARPESSOA);
		ps.setString(1,dto.getNomePessoa());
		ps.setDate(2,dto.getDtNascer());
	
		ps.setString(3,dto.getSexo());
	
		ps.setString(4,dto.getSituacao());
		ps.setString(5,dto.getEmail());
		ps.setString(6,dto.getWebPessoal());
		ps.setString(7,dto.getCpf());
		ps.setString(8,dto.getApelido());
		ps.setInt(9,dto.getChavePessoa().intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public Collection buscarPessoasPorParteDoNome(String parametroBusca) throws SQLException {
		String SQL_BUSCARPESSOASPORNOME = "SELECT * FROM maiorPessoa WHERE nomePessoa LIKE '%"+parametroBusca+"%' ORDER BY nomePessoa;";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARPESSOASPORNOME);
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		PessoaDTO dto;
		while(rs.next()){
			dto = new PessoaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	public PessoaDTO getUltimoInserido() throws SQLException{
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCAULTIMOINSERIDO);
		Integer chaveUltimoInserido;
		if(rs.next()){
			chaveUltimoInserido = new Integer(rs.getInt("chavePessoa"));
			return buscarPessoa(chaveUltimoInserido);
		}
		return null;
		
	}
	private void putDto(ResultSet rs, PessoaDTO dto) throws SQLException{
		dto.setChavePessoa(new Integer(rs.getInt("chavePessoa")));
		dto.setNomePessoa(rs.getString("nomePessoa"));
		dto.setDtNascer(rs.getDate("dtNascer"));
		dto.setCpf(rs.getString("cpf"));
		dto.setSexo(rs.getString("sexo"));
		dto.setSituacao(rs.getString("situacao"));
		dto.setWebPessoal(rs.getString("webPessoal"));
		dto.setApelido(rs.getString("apelido"));
		dto.setEmail(rs.getString("email"));
	}
	public void alterarDadosCadastrais(PessoaDTO dto) throws SQLException {
		String SQL_ALTERARDADOSCADASTRAIS = "UPDATE maiorPessoa SET email = ?, "
	        + "webPessoal = ?,apelido = ? WHERE ( chavePessoa = ? )";
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARDADOSCADASTRAIS);
		ps.setString(1,dto.getEmail());
		ps.setString(2,dto.getWebPessoal());
		ps.setString(3,dto.getApelido());
		ps.setInt(4,dto.getChavePessoa().intValue());
		ps.executeUpdate();	
	
	}
	public Collection buscarPessoasAtivas() throws SQLException {
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTARTODASPESSOAS_ATIVAS);
		Collection col = new ArrayList();
		PessoaDTO dto;
		while(rs.next()){
			dto = new PessoaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	public Collection buscarPessoasAtivas(String parametroBusca) throws SQLException {
		String SQL_BUSCARPESSOASATIVASPORNOME = "SELECT * FROM maiorPessoa WHERE situacao = 'A' AND nomePessoa LIKE '%"+parametroBusca+"%' ORDER BY nomePessoa;";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARPESSOASATIVASPORNOME);
		Collection col = new ArrayList();
		PessoaDTO dto;
		while(rs.next()){
			dto = new PessoaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
}
