package dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import dto.ProfessorDTO;

public class ProfessorDAO extends DAOBase{
	
	public static final String SQL_BUSCARPROFESSOR = "SELECT A.chavePessoa, " +
		"A.nomePessoa, A.dtNascer, A.cpf, A.sexo, B.situacao, " +
		"A.email, A.apelido, "+
		"A.webPessoal,B.dtRegistro, B.codigoCursoVinculo, " +
		"B.matriculaFuncional, B.maiorTitulo FROM maiorPessoa A, maiorProfessor B" +
		" WHERE "+
		"B.chavePessoa = ? AND A.chavePessoa = B.chavePessoa ORDER BY A.nomePessoa ";
	
	public static final String SQL_CADASTRARPROFESSOR = "INSERT INTO maiorProfessor VALUES(?,?,?,?,?,?)";
	public static final String SQL_EXCLUIRPROFESSOR = "DELETE FROM maiorProfessor WHERE chavePessoa = ?";
	public static final String SQL_ALTERAPROFESSOR = "UPDATE maiorProfessor SET dtRegistro = ?, codigoCursoVinculo = ?, matriculaFuncional = ?, situacao =  ?, maiorTitulo = ? WHERE (chavePessoa = ?)";
	
	public Collection buscarProfessorPorNome(String nomeProfessor) throws SQLException{
		String SQL_BUSCARPROFESSORPORNOME = "SELECT A.chavePessoa, A.nomePessoa, A.dtNascer, A.cpf, A.sexo, B.situacao, A.email, A.apelido,"+
		"A.webPessoal,B.dtRegistro, B.codigoCursoVinculo, B.matriculaFuncional, B.maiorTitulo FROM maiorPessoa A, maiorProfessor B WHERE A.nomePessoa "+
		"LIKE '%"+nomeProfessor+"%' AND A.chavePessoa = B.chavePessoa ORDER BY A.nomePessoa ";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARPROFESSORPORNOME);
		ProfessorDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new ProfessorDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		
		return col;
	}
	public Collection buscarProfessorPorNomeDiscplina(String nomeProfessor, String disciplina) throws SQLException {

		String SQL_BUSCARPROFESSORPORNOMEDISCIPLINA = "SELECT DISTINCT p.chavePessoa, p.nomePessoa, p.dtNascer, p.cpf, p.sexo, p.situacao, p.email, p.apelido,"+
		"p.webPessoal, f.matriculaFuncional, f.situacao ,f.dtRegistro ,f.codigoCursoVinculo ,f.maiorTitulo "+
		"FROM maiorPessoa p, maiorProfessor f, maiorTurma t, maiorDisciplina d"+
		" WHERE p.chavePessoa = f.chavePessoa AND p.chavePessoa = t.chavePessoaProfessor"+
		" AND d.idDisciplina = t.idDisciplina AND d.nomeDisciplina LIKE('%"+disciplina+"%') AND P.nomePessoa "+
		" LIKE '%"+nomeProfessor+"%' ORDER BY p.nomePessoa ";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARPROFESSORPORNOMEDISCIPLINA);
		ProfessorDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new ProfessorDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		
		return col;
	}
	public Collection buscarProfessorPorDiscplina(String disciplina) throws SQLException{
		
		String SQL_BUSCARPROFESSORPORDISCIPLINA = "SELECT DISTINCT p.chavePessoa, p.nomePessoa, p.dtNascer, p.cpf, p.sexo, p.situacao, p.email, p.apelido,"+
		"p.webPessoal, f.matriculaFuncional, f.situacao ,f.dtRegistro ,f.codigoCursoVinculo ,f.maiorTitulo "+
		"FROM maiorPessoa p, maiorProfessor f, maiorTurma t, maiorDisciplina d"+
		" WHERE p.chavePessoa = f.chavePessoa AND p.chavePessoa = t.chavePessoaProfessor"+
		" AND d.idDisciplina = t.idDisciplina AND d.nomeDisciplina like('%"+disciplina+"%') ORDER BY p.nomePessoa ";
		
		System.out.println(SQL_BUSCARPROFESSORPORDISCIPLINA);
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCARPROFESSORPORDISCIPLINA);
		ProfessorDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new ProfessorDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		
		return col;
	}
	public ProfessorDTO buscarProfessor(Integer chavePessoa) throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARPROFESSOR);
		ps.setInt(1,chavePessoa.intValue());
		ProfessorDTO dto = new ProfessorDTO();
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDto(rs,dto);
		return dto;
	}
	public void alterarProfessor(ProfessorDTO dto) throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERAPROFESSOR);
		ps.setDate(1,dto.getDtRegistro());
		ps.setInt(2,dto.getCodigoCursoVinculo().intValue());
		ps.setString(3,dto.getMatriculaFuncional());
		ps.setString(4,dto.getSituacao());
		ps.setString(5,dto.getMaiorTitulo());
		ps.setInt(6,dto.getChavePessoa().intValue());
		ps.executeUpdate();
		ps.close();
	}
	public void excluir(Integer chavePessoa) throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_EXCLUIRPROFESSOR);
		ps.setInt(1,chavePessoa.intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public void cadastrarProfessor(ProfessorDTO dto) throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARPROFESSOR);
		ps.setInt(1,dto.getChavePessoa().intValue());
		ps.setDate(2,dto.getDtRegistro());
		ps.setInt(3,dto.getCodigoCursoVinculo().intValue());
		ps.setString(4,dto.getMaiorTitulo());
		ps.setString(5,dto.getSituacao());
		ps.setString(6,dto.getMatriculaFuncional());
		ps.executeUpdate();
		ps.close();
	}
	
	private void putDto(ResultSet rs, ProfessorDTO dto) throws SQLException{
		dto.setChavePessoa(new Integer(rs.getInt("chavePessoa")));
		dto.setNomePessoa(rs.getString("nomePessoa"));
		dto.setDtNascer(rs.getDate("dtNascer"));
		dto.setCpf(rs.getString("cpf"));
		dto.setSexo(rs.getString("sexo"));
		dto.setSituacao(rs.getString("situacao"));//pegando situacao de professor nao de pessoa
		dto.setWebPessoal(rs.getString("webPessoal"));
		dto.setEmail(rs.getString("email"));
		dto.setApelido(rs.getString("apelido"));
		
		
		dto.setDtRegistro(rs.getDate("dtRegistro"));
		dto.setCodigoCursoVinculo(new Integer(rs.getInt("codigoCursoVinculo")));
		dto.setMatriculaFuncional(rs.getString("matriculaFuncional"));
		dto.setMaiorTitulo(rs.getString("maiorTitulo"));
	}
	public void alterarDadosCadastrais(ProfessorDTO dto) throws SQLException {
		String SQL_ALTERADADOSCADASTRAISPROFESSOR = "UPDATE  maiorPessoa p, maiorProfessor pro SET pro.codigoCursoVinculo = ?, pro.maiorTitulo = ?," +
				" p.apelido = ?,p.email = ?,p.webPessoal = ? " +
				"WHERE (p.chavePessoa = ? AND pro.chavePessoa = ?)";
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERADADOSCADASTRAISPROFESSOR);
		ps.setInt(1,dto.getCodigoCursoVinculo().intValue());
		ps.setString(2,dto.getMaiorTitulo());
		ps.setString(3,dto.getApelido());
		ps.setString(4,dto.getEmail());
		ps.setString(5,dto.getWebPessoal());
		ps.setInt(6,dto.getChavePessoa().intValue());
		ps.setInt(7,dto.getChavePessoa().intValue());
		ps.executeUpdate();
		ps.close();
		
	}

}
