package dao;

import java.sql.*;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;

import dto.TurmaDTO;
import dto.Turma_Curso_Disciplina_ProfessorDTO;

public class TurmaDAO extends DAOBase{
	
    private static final String SQL_ALTERARTURMA = "update maiorTurma set chavepessoaprofessor = ?, diasemana = ?, horarioaula = ?, turno = ?, sala = ? where ( codigoturma = ? and codigocurso = ? and iddisciplina = ? and ano = ? and semestre = ?)";
	private static final String SQL_DELETARTURMA = "delete from maiorTurma where ( codigoturma = ? and codigocurso = ? and iddisciplina = ? and ano = ? and semestre = ?)";
	private static final String SQL_CADASTRARTURMA = "insert into maiorTurma values (?,?,?,?,?,?,?,?,?,?)";
	private static final String SQL_LISTARTODOSTURMA = "select * from maiorTurma turma inner join maiorCurso curso on curso.codigoCurso=turma.codigoCurso inner join maiorDisciplina disciplina on disciplina.idDisciplina=turma.idDisciplina order by turma.ano, turma.semestre, curso.nomeCurso,disciplina.nomeDisciplina, turma.codigoturma";
	private static final String SQL_BUSCARTURMA = "select * from maiorTurma turma inner join maiorCurso curso on turma.codigoCurso=curso.codigoCurso inner join maiorDisciplina disciplina on disciplina.idDisciplina=turma.idDisciplina inner join maiorPessoa pessoa on turma.chavePessoaProfessor=pessoa.chavePessoa where ( turma.codigoturma = ? and turma.codigocurso = ? and turma.iddisciplina = ? and turma.ano = ? and turma.semestre = ?)";
	
	public Collection listarTodasTurmas() throws SQLException{
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTARTODOSTURMA);
		Collection col = new ArrayList();
		TurmaDTO dto;
		while(rs.next()){
			dto = new TurmaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public void cadastrarTurma(TurmaDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARTURMA);
		ps.setString(1,dto.getCodigoTurma());
		ps.setInt(2,dto.getCodigoCurso().intValue());
		ps.setInt(3,dto.getIdDisciplina().intValue());
		ps.setInt(4,dto.getAno().intValue());
		ps.setString(5,dto.getSemestre());
		ps.setInt(6,dto.getChavePessoaProfessor().intValue());
		ps.setString(7,dto.getDiaSemana());
		ps.setString(8,dto.getHorarioAula());
		ps.setString(9,dto.getTurno());
		ps.setString(10,dto.getSala());
		
		ps.executeUpdate();
		ps.close();
	}
	
	public void excluirTurma(String codigoTurma, Integer codigoCurso, Integer idDisciplina, Integer ano, Integer semestre) throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_DELETARTURMA);
		ps.setString(1,codigoTurma);
		ps.setInt(2,codigoCurso.intValue());
		ps.setInt(3,idDisciplina.intValue());
		ps.setInt(4,ano.intValue());
		ps.setInt(5,semestre.intValue());
		ps.executeUpdate();
		ps.close();

		
	}
	
	public TurmaDTO buscarTurma(String codigoTurma, Integer codigoCurso, Integer idDisciplina, Integer ano, String semestre) throws SQLException {
		TurmaDTO dto = new TurmaDTO();

		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARTURMA);
		ps.setString(1,codigoTurma);
		ps.setInt(2,codigoCurso.intValue());
		ps.setInt(3,idDisciplina.intValue());
		ps.setInt(4,ano.intValue());
		ps.setString(5,semestre);
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDtoVisualizacao(rs,dto);
		rs.close();
		ps.close();
		return dto;
		
	}
	
	public void alterarTurma(TurmaDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARTURMA);
		
		ps.setInt(1,dto.getChavePessoaProfessor().intValue());
		ps.setString(2,dto.getDiaSemana());
		ps.setString(3,dto.getHorarioAula());
		ps.setString(4,dto.getTurno());
		ps.setString(5,dto.getSala());
		ps.setString(6,dto.getCodigoTurma());
		ps.setInt(7,dto.getCodigoCurso().intValue());
		ps.setInt(8,dto.getIdDisciplina().intValue());
		ps.setInt(9,dto.getAno().intValue());
		ps.setString(10,dto.getSemestre());
		
		ps.executeUpdate();
		ps.close();
	}
	
	public Collection buscarTurmasPorCodigoEDisciplina(String parteCodigo, String nomeDisciplina, String ano, String semestre) throws SQLException, ParseException {
		String select = montaSelect(parteCodigo, nomeDisciplina, ano, semestre);
		PreparedStatement ps = getConnection().prepareStatement(select);
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		Turma_Curso_Disciplina_ProfessorDTO dto;
		while(rs.next()){
			dto = new Turma_Curso_Disciplina_ProfessorDTO();
			putDtoTurmaParaListagem(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public Collection buscarTurmasPorCodigoEDisciplinaEChaveAluno(String parteCodigo, String nomeDisciplina, String ano, String semestre, String chaveAluno) throws SQLException, ParseException {
		String select = montaSelectComAluno(parteCodigo, nomeDisciplina, ano, semestre, chaveAluno);
		PreparedStatement ps = getConnection().prepareStatement(select);
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		Turma_Curso_Disciplina_ProfessorDTO dto;
		while(rs.next()){
			dto = new Turma_Curso_Disciplina_ProfessorDTO();
			putDtoTurmaParaListagem(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public Collection buscarTurmasPorCodigoEDisciplinaEMonitor(String parteCodigo, String nomeDisciplina, String ano, String semestre, String chaveMonitor) throws SQLException, ParseException {
		String select = montaSelectComMonitor(parteCodigo, nomeDisciplina, ano, semestre, chaveMonitor);
		PreparedStatement ps = getConnection().prepareStatement(select);
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		Turma_Curso_Disciplina_ProfessorDTO dto;
		while(rs.next()){
			dto = new Turma_Curso_Disciplina_ProfessorDTO();
			putDtoTurmaParaListagem(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	private String montaSelect(String parteCodigo, String nomeDisciplina, String ano, String semestre) {
		StringBuffer select = new StringBuffer();
		select.append("select * from maiorTurma turma ");
		select.append("inner join maiorCurso curso on curso.codigocurso=turma.codigocurso ");
		select.append("inner join maiorDisciplina disciplina on disciplina.iddisciplina=turma.iddisciplina ");
		select.append("inner join maiorPessoa pessoa on pessoa.chavepessoa=turma.chavepessoaprofessor ");
		select.append("where turma.codigoturma like '%"+parteCodigo+"%'  and disciplina.nomedisciplina like '%"+nomeDisciplina+"%' ");
		if(ano!=null && !ano.equals(""))
			select.append("and turma.ano='"+ano+"' ");
		if(semestre!=null && !semestre.equals(""))
			select.append("and turma.semestre='"+semestre+"' ");
		select.append("order by turma.ano, turma.semestre, curso.nomeCurso, disciplina.idDisciplina, turma.codigoturma ");
		return select.toString();
	}
	
	private String montaSelectComAluno(String parteCodigo, String nomeDisciplina, String ano, String semestre, String chaveAluno) {
		StringBuffer select = new StringBuffer();
		select.append("select * from maiorTurma turma ");
		select.append("inner join maiorCurso curso on curso.codigocurso=turma.codigocurso ");
		select.append("inner join maiorDisciplina disciplina on disciplina.iddisciplina=turma.iddisciplina ");
		select.append("inner join maiorPessoa pessoa on pessoa.chavepessoa=turma.chavepessoaprofessor ");
		select.append("inner join maiorTurma_Aluno relTurma on relTurma.codigoTurma=turma.codigoTurma and relTurma.codigoCurso=turma.codigoCurso and relTurma.idDisciplina=turma.idDisciplina and relTurma.ano=turma.ano and relTurma.semestre=turma.semestre  ");
		select.append("where turma.codigoturma like '%"+parteCodigo+"%'  and disciplina.nomedisciplina like '%"+nomeDisciplina+"%' ");
		
		if(ano!=null && !ano.equals(""))
			select.append("and turma.ano='"+ano+"' ");
		
		if(semestre!=null && !semestre.equals(""))
			select.append("and turma.semestre='"+semestre+"' ");
		
		if(chaveAluno!= null && !chaveAluno.equals(""))
			select.append("and relTurma.chavePessoaAluno='"+chaveAluno+"' ");
			
		select.append("order by turma.ano, turma.semestre, curso.nomeCurso, disciplina.idDisciplina, turma.codigoturma ");
		return select.toString();
	}
	
	private String montaSelectComMonitor(String parteCodigo, String nomeDisciplina, String ano, String semestre, String chaveMonitor) {
		StringBuffer select = new StringBuffer();
		select.append("select * from maiorTurma turma ");
		select.append("inner join maiorCurso curso on curso.codigocurso=turma.codigocurso ");
		select.append("inner join maiorDisciplina disciplina on disciplina.iddisciplina=turma.iddisciplina ");
		select.append("inner join maiorPessoa pessoa on pessoa.chavepessoa=turma.chavepessoaprofessor ");
		select.append("inner join maiorTurma_Aluno relTurma on relTurma.codigoTurma=turma.codigoTurma and relTurma.codigoCurso=turma.codigoCurso and relTurma.idDisciplina=turma.idDisciplina and relTurma.ano=turma.ano and relTurma.semestre=turma.semestre  ");
		select.append("inner join maiorMonitor monitoria on monitoria.idDisciplina=disciplina.iddisciplina ");
		select.append("where turma.codigoturma like '%"+parteCodigo+"%'  and disciplina.nomedisciplina like '%"+nomeDisciplina+"%' ");
		
		if(ano!=null && !ano.equals(""))
			select.append("and turma.ano='"+ano+"' ");
		
		if(semestre!=null && !semestre.equals(""))
			select.append("and turma.semestre='"+semestre+"' ");
		
		if(chaveMonitor!= null && !chaveMonitor.equals(""))
			select.append("and monitoria.chavePessoa='"+chaveMonitor+"' ");
			
		select.append("group by turma.codigoTurma,turma.codigoCurso,turma.idDisciplina,turma.semestre,turma.ano ");
		select.append("order by turma.ano, turma.semestre, curso.nomeCurso, disciplina.idDisciplina, turma.codigoturma ");
		return select.toString();
	}

	public void putDto(ResultSet rs, TurmaDTO dto) throws SQLException{
		dto.setCodigoTurma(rs.getString("codigoTurma"));
		dto.setCodigoCurso(new Integer(rs.getString("codigoCurso")));
		dto.setIdDisciplina(new Integer(rs.getString("idDisciplina")));
		dto.setAno(new Integer(rs.getString("ano")));
		dto.setSemestre(rs.getString("semestre"));
		dto.setChavePessoaProfessor(new Integer(rs.getString("chavePessoaProfessor")));
		dto.setDiaSemana(rs.getString("diaSemana"));
		dto.setHorarioAula(rs.getString("horarioAula"));
		dto.setTurno(rs.getString("turno"));
		dto.setSala(rs.getString("sala"));
	}
	
	public void putDtoVisualizacao(ResultSet rs, TurmaDTO dto) throws SQLException{
		dto.setCodigoTurma(rs.getString("turma.codigoTurma"));
		dto.setCodigoCurso(new Integer(rs.getString("turma.codigoCurso")));
		dto.setIdDisciplina(new Integer(rs.getString("turma.idDisciplina")));
		dto.setAno(new Integer(rs.getString("turma.ano")));
		dto.setSemestre(rs.getString("turma.semestre"));
		dto.setChavePessoaProfessor(new Integer(rs.getString("turma.chavePessoaProfessor")));
		dto.setDiaSemana(rs.getString("turma.diaSemana"));
		dto.setHorarioAula(rs.getString("turma.horarioAula"));
		dto.setTurno(rs.getString("turma.turno"));
		dto.setSala(rs.getString("turma.sala"));
		dto.setNomeCurso(rs.getString("curso.nomeCurso"));
		dto.setNomeDisciplina(rs.getString("disciplina.nomeDisciplina"));
		dto.setNomeProfessor(rs.getString("pessoa.nomePessoa"));
	}
	
	public void putDtoTurmaParaListagem(ResultSet rs, Turma_Curso_Disciplina_ProfessorDTO dto) throws SQLException{
		dto.setCodigoTurma(rs.getString("codigoTurma"));
		dto.setCodigoCurso(new Integer(rs.getString("codigoCurso")));
		dto.setIdDisciplina(new Integer(rs.getString("idDisciplina")));
		dto.setAno(new Integer(rs.getString("ano")));
		dto.setSemestre(rs.getString("semestre"));
		dto.setChavePessoaProfessor(new Integer(rs.getString("chavePessoaProfessor")));
		dto.setDiaSemana(rs.getString("diaSemana"));
		dto.setHorarioAula(rs.getString("horarioAula"));
		dto.setTurno(rs.getString("turno"));
		dto.setSala(rs.getString("sala"));
		dto.setNomeProfessor(rs.getString("nomePessoa"));
		dto.setNomeCurso(rs.getString("nomeCurso"));
		dto.setNomeDisciplina(rs.getString("nomeDisciplina"));
	}

}
