package mina.action;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import acao.Acao;
import mina.model.AnimationModel;
import slave.Dominio;
import dto.LoginDTO;

public class DeleteAnimationAction implements Acao {
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception 
	{
		if(((Integer)req.getSession().getAttribute("perfil")).intValue() != Dominio.getAdministrador().intValue())
		{
			return "/jsp/mina/accessDenied.jsp";
		}
		else
		{
			try{
				(new AnimationModel((LoginDTO)req.getSession().getAttribute("loginDTO"))).delete(new Integer(req.getParameter("id")));
				this.deleteFile(req, req.getParameter("id"));
				req.setAttribute("message","Animao excluda.");
			}catch (com.mysql.jdbc.exceptions.MySQLIntegrityConstraintViolationException e) {
				req.setAttribute("message","A animao no pde ser excluda porque est em uso. Desvincule-a das regras que a estejam usando e tente novamente.");
			}catch (Exception e) {
				e.printStackTrace();
				req.setAttribute("message","Desculpe, houve um erro ao tentar excluir a animao.");
			}

			OpenConfigureAction action = new OpenConfigureAction();
			return action.executar(req, resp);
		}
	}
	
	private void deleteFile(HttpServletRequest req, String id)
	{
		File file = new File(req.getSession().getServletContext().getRealPath("/") + "animation/"+id.toString()+".swf");
		file.delete();
	}
}
