package mina.action;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.servlet.http.*;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;
import mina.dto.AnimationDTO;
import mina.model.AnimationModel;

public class NewAnimationAction implements Acao{

	@SuppressWarnings("unchecked")
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		if(((Integer)req.getSession().getAttribute("perfil")).intValue() != Dominio.getAdministrador().intValue())
		{
			return "/jsp/mina/accessDenied.jsp";
		}
		else
		{
			AnimationDTO dto = new AnimationDTO();
			AnimationModel model = new AnimationModel((LoginDTO)req.getSession().getAttribute("loginDTO"));
			boolean isMultiPart = ServletFileUpload.isMultipartContent(req);
			FileItem fileItem = null;
			
			if(isMultiPart)
			{
				FileItemFactory factory = new DiskFileItemFactory();
				ServletFileUpload upload = new ServletFileUpload(factory);
				
				try
				{
					Iterator<FileItem> iter = upload.parseRequest(req).iterator();
					while(iter.hasNext())
					{
						FileItem item = iter.next();
						
						if (item.getFieldName().equals("name"))
						{
							dto.setName(item.getString());
						}
						if (item.getFieldName().equals("description"))
						{
							dto.setDescription(item.getString());
						}
						if(!item.isFormField())
						{
							if(item.getName().length() > 0)
							{
								fileItem = item;
							}
						}
					}
					if(fileItem.getName().substring(fileItem.getName().lastIndexOf(".")).toLowerCase().equals(".swf"))
					{
						model.save(dto);
						this.saveFile(fileItem,req,dto);
						req.setAttribute("message","Animao cadastrada!");
					}
					else
					{
						req.setAttribute("message","Arquivo invlido!");
					}
				}
				catch(FileUploadException e)
				{
					e.printStackTrace();
					req.setAttribute("message","Desculpe, houve um erro interno.");
				}
				catch(Exception e)
				{
					e.printStackTrace();
					req.setAttribute("message","Desculpe, houve um erro interno!");
				}
			}
			
			OpenConfigureAction action = new OpenConfigureAction();
			return action.executar(req, resp);
		}
	}
	
	private void saveFile(FileItem item, HttpServletRequest req, AnimationDTO dto) throws IOException
	{
		String path = req.getSession().getServletContext().getRealPath("/") + "animation";
		
		File dir = new File(path);
		if(!dir.exists())
		{
			dir.mkdir();
		}
		
		String name = dto.getId().toString()+".swf";
		FileOutputStream output = new FileOutputStream(new File(dir,name));
		InputStream input = item.getInputStream();
		byte[] buffer = new byte[2048];
		int nRead;
		while((nRead = input.read(buffer)) >= 0)
		{
			output.write(buffer,0,nRead);
		}
		
		output.flush();
		output.close();
	}
}
