package mina.action;

import java.util.Collection;
import javax.servlet.http.*;

import slave.Dominio;
import dto.LoginDTO;
import mina.model.AnimationModel;
import acao.Acao;
import mina.dto.AnimationDTO;

public final class OpenConfigureAction implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		if(((Integer)req.getSession().getAttribute("perfil")).intValue() != Dominio.getAdministrador().intValue())
		{
			return "/jsp/mina/accessDenied.jsp";
		}
		else
		{
			HttpSession session = req.getSession(false);
			session.setAttribute("context","MINA");
			session.setAttribute("currentAction","Configurar");

			LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
			AnimationModel model = new AnimationModel(login);
			try{
				Collection<AnimationDTO> all = model.getAll();
				req.setAttribute("animationList", all);
			}catch (Exception e) {
				req.setAttribute("message","Desculpe, houve um erro interno.");
			}

			return "/jsp/mina/config.jsp";
		}
	}
}
