package mina.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import slave.Dominio;
import mina.model.AnimationModel;
import dto.LoginDTO;
import acao.Acao;

public final class ViewAnimationAction implements Acao{
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception 
	{
		if(((Integer)req.getSession().getAttribute("perfil")).intValue() != Dominio.getAdministrador().intValue())
		{
			return "/jsp/mina/accessDenied.jsp";
		}
		else
		{
			AnimationModel model = new AnimationModel((LoginDTO)req.getSession().getAttribute("loginDTO"));
			try{
				req.setAttribute("animationDTO", model.get(new Integer(req.getParameter("id"))));
			}catch (Exception e) {
				req.setAttribute("message","Desculpe, animao no encontrada.");
			}

			return "/jsp/mina/viewAnimation.jsp";
		}
	}
}
