package mina.dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import mina.dto.AnimationDTO;

import dao.DAOBase;

public class AnimationDAO extends DAOBase{
	
    //private final String SQL_ALTERARCURSO = "update maiorCurso set nomecurso = ? where ( codigocurso = ? )";
	private final String SQL_DELETE = "DELETE FROM minaAnimation WHERE ID = ? LIMIT 1";
	private final String SQL_INSERT = "INSERT INTO minaAnimation(name,description) VALUES(?,?)";
	private final String SQL_GETALL = "SELECT * FROM minaAnimation ORDER BY id";
	private final String SQL_GETLASTID = "SELECT LAST_INSERT_ID() AS id";
	private final String SQL_GET = "SELECT * FROM minaAnimation WHERE id = ? LIMIT 1";
	
	public Collection<AnimationDTO> getAll() throws SQLException
	{
		ResultSet rs = getConnection().createStatement().executeQuery(this.SQL_GETALL);
		Collection<AnimationDTO> col = new ArrayList<AnimationDTO>();
		AnimationDTO dto;
		while(rs.next()){
			dto = new AnimationDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public AnimationDTO save(AnimationDTO dto) throws SQLException
	{
		if(dto.getId() == null)
		{
			this.insert(dto);
			dto.setId(this.getLastId());
		}
		return dto;
	}
	
	private void insert(AnimationDTO dto) throws SQLException 
	{
		PreparedStatement ps = getConnection().prepareStatement(this.SQL_INSERT);

		ps.setString(1,dto.getName());
		ps.setString(2,dto.getDescription());
		
		ps.executeUpdate();
		ps.close();
	}
	
	private int getLastId() throws SQLException
	{
		ResultSet rs = getConnection().createStatement().executeQuery(this.SQL_GETLASTID);
		rs.next();
		int id = rs.getInt("id");
		rs.close();
		return id;
	}
	
	public AnimationDTO get(Integer id) throws SQLException 
	{	
		AnimationDTO dto = new AnimationDTO();

		PreparedStatement ps = this.getConnection().prepareStatement(this.SQL_GET);
		ps.setInt(1,id.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			this.putDto(rs,dto);
		rs.close();
		ps.close();
		return dto;
		
	}


	public void delete(Integer id) throws SQLException
	{
		PreparedStatement ps = getConnection().prepareStatement(this.SQL_DELETE);
		ps.setInt(1,id.intValue());
		ps.executeUpdate();
		ps.close();
	}
	
/*	public CursoDTO buscarCurso(Integer codigoCurso) throws SQLException {
		CursoDTO dto = new CursoDTO();

		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARCURSO);
		ps.setInt(1,codigoCurso.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDto(rs,dto);
		rs.close();
		ps.close();
		return dto;
		
	}
	
	public void alterarCurso(CursoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARCURSO);
		ps.setString(1,dto.getNomeCurso());
		ps.setInt(2,dto.getCodigoCurso().intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public Collection buscarCursosPorParteDoNome(String parametroBusca) throws SQLException {
		String SQL_BUSCARCURSOSPORNOME = "select * from maiorCurso where nomecurso like '%"+parametroBusca+"%' order by nomecurso;";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARCURSOSPORNOME);
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		CursoDTO dto;
		while(rs.next()){
			dto = new CursoDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}*/
	
	private void putDto(ResultSet rs, AnimationDTO dto) throws SQLException{
		dto.setId(new Integer(rs.getInt("id")));
		dto.setName(rs.getString("name"));
		dto.setDescription(rs.getString("description"));
	}
}
