package mina.mail;

import java.util.Date;
import java.util.Properties;

import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import dto.PessoaDTO;

public class Mail {
	public void sendSingle(PessoaDTO to, String content, String subject) throws Exception
	{	
		Properties p = new Properties();
		MailAuthenticator authenticator = new MailAuthenticator();
		p.put("mail.smtp.host",authenticator.getHost());
		p.put("mail.smtp.auth","true"); 
		p.put("mail.smtp.starttls.enable",authenticator.getStarttls());

		Session session = Session.getInstance(p,authenticator);  
		MimeMessage msg = new MimeMessage(session);
		
		msg.setFrom(authenticator.getSender());  
		msg.setRecipient(Message.RecipientType.TO, new InternetAddress(to.getEmail()));  
		msg.setSentDate(new Date());  
		msg.setSubject(subject);  
		msg.setText(content,"utf8","html");  
		System.out.println("Sending mail..."); 
		Transport.send(msg);
		System.out.println("Mail sent.");
	}
}
