package mina.mail;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import javax.mail.*;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletException;
import java.util.*;

public class MailAuthenticator extends Authenticator{

	private Properties prop = new Properties();
	private String propertiesFile = "mail.properties";
	
	public final String getHost() {
		System.out.println(this.prop.getProperty("host"));
		return this.prop.getProperty("host");
	}

	public final String getAuth() {
		System.out.println("auth: "+this.prop.getProperty("auth"));
		return this.prop.getProperty("auth");
	}

	public final String getStarttls() {
		System.out.println(this.prop.getProperty("starttls"));
		return this.prop.getProperty("starttls");
	}

	public final String getPort() {
		return this.prop.getProperty("port");
	}

	public final InternetAddress getSender() throws UnsupportedEncodingException {
		System.out.println(this.prop.getProperty("sendername"));
		return new InternetAddress(this.prop.getProperty("sendermail"),this.prop.getProperty("sendername"));
	}
	
	public MailAuthenticator() throws ServletException {
		try {
			InputStream str = this.getClass().getClassLoader().getResourceAsStream(this.propertiesFile);
			if (str == null) {
				throw new ServletException("No foi possivel encontrar o arquivo de conexao");
			}
			this.prop.load(str);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	protected PasswordAuthentication getPasswordAuthentication() {
		return new PasswordAuthentication(this.prop.getProperty("user"), this.prop.getProperty("password"));
	}
}