package mina.model;

import java.sql.SQLException;
import java.util.Collection;

import mina.dao.AnimationDAO;
import mina.dto.AnimationDTO;
import model.ModelBase;

import dao.DAOFactory;
import dto.LoginDTO;

public final class AnimationModel extends ModelBase{
	private AnimationDAO dao;

	public AnimationModel(LoginDTO login) throws SQLException {
		super(login);
		this.getDao();
	}

	public Collection<AnimationDTO> getAll() throws SQLException {
		Collection<AnimationDTO> result;
		result = this.dao.getAll();
		fechaConexao(dao);
		return result;
	}

	public void save(AnimationDTO dto) throws SQLException {
		this.dao.save(dto);
		fechaConexao(dao);
	}
	
	public AnimationDTO get(Integer id) throws SQLException {
		AnimationDTO dto = this.dao.get(id);
		fechaConexao(dao);
		return dto;
	}


	public void delete(Integer id) throws SQLException {
		this.dao.delete(id);
		fechaConexao(dao);
	}
/*
	public CursoDTO buscarCurso(Integer codigoCurso) throws SQLException {
		CursoDTO dto;
//		abreConexao(getDao(),dao);
		dto = getDao().buscarCurso(codigoCurso);
		fechaConexao(dao);
		return dto;
	}

	public void alterarCurso(CursoDTO dto) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().alterarCurso(dto);
		fechaConexao(dao);
	}

	public Collection buscarCursosPorParteDoNome(String parametroBusca) throws SQLException {
		Collection result;
//		abreConexao(getDao(),dao);
		result = getDao().buscarCursosPorParteDoNome(parametroBusca);
		fechaConexao(dao);
		return result;
	}

*/
	private void getDao() throws SQLException {
			try 
			{
				this.dao = (AnimationDAO)DAOFactory.getInstance().getDAO("mina.dao.AnimationDAO",getLoginDTOUsuarioLogado());
			}
			catch (ClassNotFoundException e)
			{
				e.printStackTrace();
			}
			catch (IllegalAccessException e)
			{
				e.printStackTrace();
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
			catch (InstantiationException e)
			{
				e.printStackTrace();
			}
	}
}