package model;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collection;

import dao.AlunoDaTurmaDAO;
import dao.DAOFactory;
import dto.AlunoDTO;
import dto.LoginDTO;

public class AlunoDaTurmaModel extends ModelBase{
	private AlunoDaTurmaDAO dao;

	public AlunoDaTurmaModel(LoginDTO login){
		super(login);
	}

	public Collection buscaAlunos(String nomeAluno, String matricula) throws SQLException {
		Collection result;
		getDao();
		if (matricula.equalsIgnoreCase("")) {
			result = dao.buscarAlunoPorNome(nomeAluno);
		}else 
			result = dao.buscarAlunoPorMatricula(matricula);
		return result;
	}

	public Collection buscaAlunosDaTurma(String nomeAluno, String matricula, String codigoTurma,
			Integer codigoCurso, Integer idDisciplina, Integer ano, String semestre)
			throws SQLException {
		Collection result;
		getDao();	
		if (matricula.equalsIgnoreCase("")) {
			result = dao.buscarAlunoDaTurmaPorNome(nomeAluno, codigoTurma, codigoCurso,
					idDisciplina, ano, semestre);
		}else
			result = dao.buscarAlunoDaTurmaPorMatricula(matricula, codigoTurma, codigoCurso,
				idDisciplina, ano, semestre);
		return result;
	}

	public AlunoDaTurmaDAO getDao() throws SQLException {
//		if (dao == null)
			try {
				dao = (AlunoDaTurmaDAO) DAOFactory.getInstance().getDAO("dao.AlunoDaTurmaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return dao;
	}

	public boolean isAlunoCatolicaVirtual(Integer chavePessoa)  {
		try {
			boolean bool;
//			abreConexao(getDao(),dao);
			bool = getDao().isAlunoCatolicaVirtual(chavePessoa);
			fechaConexao(dao);
			return bool;
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			System.out.println("PARSE problemas ao buscar aluno da ucb virtual");
			e.printStackTrace();
			return false;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			System.out.println("SQL problemas ao buscar aluno da ucb virtual");
			e.printStackTrace();
			return false;
		}
	}
	public AlunoDTO buscarAluno(Integer chavePessoa) throws SQLException {
		AlunoDTO dto;
//		abreConexao(getDao(),dao);
		dto = getDao().buscarAluno(chavePessoa);
		fechaConexao(dao);
		return dto;
	}
	public void alterarAluno(AlunoDTO dto) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().alterarAluno(dto);
		fechaConexao(dao);
	}

	public void excluir(Integer chavePessoa) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().excluir(chavePessoa);
		fechaConexao(dao);
	}

	public void cadastrarAluno(AlunoDTO dto) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().cadastrarAluno(dto);
		fechaConexao(dao);
	}
}