package model;

import java.sql.SQLException;
import java.util.Collection;

import dao.AlunoDAO;
import dao.DAOFactory;
import dto.AlunoDTO;
import dto.LoginDTO;
import dto.PessoaDTO;


public class AlunoModel extends ModelBase{
	private AlunoDAO dao;
	private LoginDTO login;
	public AlunoModel(LoginDTO login){
		super(login);
		this.login = login;
	}

	public Collection buscaAlunos(String nomeAluno, String matricula) throws SQLException {
		Collection result;
		getDao();
		if(matricula.equalsIgnoreCase(""))
			result = dao.buscarAlunoPorNome(nomeAluno);//busca todos qdo nada eh passado como parametro
		else if(nomeAluno.equalsIgnoreCase(""))
			result = dao.buscarAlunoPorMatricula(matricula);
		else
			result = dao.buscarAlunoPorNomeMatricula(nomeAluno,matricula);

		fechaConexao(dao);
		return result;

	}
	public AlunoDAO getDao() throws SQLException {
//		if(dao == null)
			try {
				dao = (AlunoDAO)DAOFactory.getInstance().getDAO("dao.AlunoDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				System.out.println("Ops!!!!. \n" +
						"DAOFactory pode nao ter encontrado " +
				"usuario, senha, driver, ou database!!!");
				throw e;
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return dao;
	}
	public AlunoDTO buscarAluno(Integer chavePessoa) throws SQLException {
//		abreConexao(getDao(),dao);
		AlunoDTO dto;
		dto = getDao().buscarAluno(chavePessoa);
		fechaConexao(dao);
		return dto;

	}
	public void alterarAluno(AlunoDTO dto) throws SQLException {
		if(dto.getSituacao().equalsIgnoreCase("A"))
			ativaPessoa(dto);
//		abreConexao(getDao(),dao);
		getDao().alterarAluno(dto);
		fechaConexao(dao);
	}
	private void ativaPessoa(AlunoDTO dto) throws SQLException {
		PessoaModel model = new PessoaModel(login);
		PessoaDTO pessoa = model.buscarPessoa(dto.getChavePessoa());
		pessoa.setSituacao("A");
		model.alterarPessoa(pessoa);
	}

	public void excluir(Integer chavePessoa) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().excluir(chavePessoa);
		fechaConexao(dao);
	}
	public void cadastrarAluno(AlunoDTO dto) throws SQLException {
		if(dto.getSituacao().equalsIgnoreCase("A"))
			ativaPessoa(dto);
//		abreConexao(getDao(),dao);
		getDao().cadastrarAluno(dto);
		fechaConexao(dao);	
	}

}
