/*
 * Created on 23/01/2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package model;

import java.sql.SQLException;
import java.util.Collection;

import validacao.apoio.ApoioConteudo;
import dao.ConteudoDAO;
import dao.DAOFactory;
import dto.ConteudoDTO;
import dto.LoginDTO;

/**
 * @author daniel.freitas
 * 
 * To change the template for this generated type comment go to Window - Preferences - Java - Code
 * Generation - Code and Comments
 */
public class ConteudoModel extends ModelBase{
	private ConteudoDAO dao;
	
	public ConteudoModel(LoginDTO login) {
		super(login);
	}

	public Collection listarTodosConteudos() throws SQLException {
		Collection result;
//		abreConexao(getDao(),dao);
		result = getDao().listarTodosConteudos();
		fechaConexao(dao);
		return result;
	}

	public void cadastrarConteudo(ConteudoDTO dto) throws SQLException {
//		abreConexao(getDao(),dao);
		dto.setOrdem(new Integer(getDao().getMaiorOrdem(dto.getIdDisciplina()).intValue()+1));
		dao.cadastrarConteudo(dto);
		fechaConexao(dao);
	}

	public void excluir(Integer idConteudo) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().excluirConteudo(idConteudo);
		fechaConexao(dao);
	}

	public ApoioConteudo buscarConteudo(Integer idConteudo) throws SQLException {
		ApoioConteudo apoio;
//		abreConexao(getDao(),dao);
		apoio = getDao().buscarConteudo(idConteudo);
		fechaConexao(dao);
		return apoio;
	}

	public void alterarConteudo(ConteudoDTO dto) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().alterarConteudo(dto);
		fechaConexao(dao);
	}

	public Collection buscarConteudosPorParteDescricaoENomeDisciplina(String nomeConteudo,
			String nomeDisciplina) throws SQLException {
		Collection result;
//		abreConexao(getDao(),dao);
		
		result = getDao().buscarConteudosPorParteDescricaoENomeDisciplina(nomeConteudo,
				nomeDisciplina);
		fechaConexao(dao);
		return result;
	}

	public Collection buscarConteudosPorParteDaDescricaoEDisciplina(String parametroBusca,
			Integer idDisciplina) throws SQLException {
		Collection result;
//		abreConexao(getDao(),dao);
		result = getDao().buscarConteudosPorParteDaDescricaoEDisciplina(parametroBusca, idDisciplina);
		fechaConexao(dao);
		return result;
	}

	public Collection buscarConteudosPorDisciplina(Integer idDisciplina) throws SQLException {
		Collection result;
//		abreConexao(getDao(),dao);
		result = getDao().buscarConteudosPorDisciplina(idDisciplina);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarConteudosPorDisciplinaUsandoDTO(Integer idDisciplina) throws SQLException {
		Collection result;
//		abreConexao(getDao(),dao);
		result = getDao().buscarConteudosPorDisciplinaUsandoDTO(idDisciplina);
		fechaConexao(dao);
		return result;
	}
	public void ordenarConteudos(Collection conteudos) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().updateOrdemConteudo(conteudos);
		fechaConexao(dao);
	}
	public ConteudoDAO getDao() throws SQLException {
//		if (dao == null)
			try {
				dao = (ConteudoDAO) DAOFactory.getInstance().getDAO("dao.ConteudoDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return dao;
	}

}