package model;

import java.sql.SQLException;
import java.util.Collection;

import dao.CursoDAO;
import dao.DAOFactory;
import dto.CursoDTO;
import dto.LoginDTO;

public class CursoModel extends ModelBase{
	private CursoDAO dao;

	public CursoModel(LoginDTO login) {
		super(login);
	}

	public Collection listarTodosCursos() throws SQLException {
		Collection result;
//		abreConexao(getDao(),dao);
		result = getDao().listarTodosCursos();
		fechaConexao(dao);
		return result;
	}

	public void cadastrarCurso(CursoDTO dto) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().cadastrarCurso(dto);
		fechaConexao(dao);
	}

	public void excluir(Integer codigoCurso) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().excluirCurso(codigoCurso);
		fechaConexao(dao);
	}

	public CursoDTO buscarCurso(Integer codigoCurso) throws SQLException {
		CursoDTO dto;
//		abreConexao(getDao(),dao);
		dto = getDao().buscarCurso(codigoCurso);
		fechaConexao(dao);
		return dto;
	}

	public void alterarCurso(CursoDTO dto) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().alterarCurso(dto);
		fechaConexao(dao);
	}

	public Collection buscarCursosPorParteDoNome(String parametroBusca) throws SQLException {
		Collection result;
//		abreConexao(getDao(),dao);
		result = getDao().buscarCursosPorParteDoNome(parametroBusca);
		fechaConexao(dao);
		return result;
	}


	public CursoDAO getDao() throws SQLException {
//		if(dao == null)
			try {
				dao = (CursoDAO)DAOFactory.getInstance().getDAO("dao.CursoDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return dao;
	}


}
