package model;

import java.sql.SQLException;
import java.util.Collection;

import dao.DAOFactory;
import dao.DiretorDAO;
import dto.AlunoDTO;
import dto.DiretorDTO;
import dto.LoginDTO;
import dto.PessoaDTO;

public class DiretorModel extends ModelBase{
	private DiretorDAO dao;
	private LoginDTO login;
	public DiretorModel(LoginDTO login) {
		super(login);
		this.login = login;
	}

	public void alterarDiretor(DiretorDTO dto){
//		abreConexao(getDao(),dao);
		try {
			if(dto.getSituacao().equalsIgnoreCase("A"))
				ativaPessoa(dto);
			getDao().alterarDiretor(dto);
			fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	private void ativaPessoa(DiretorDTO dto) throws SQLException {
		PessoaModel model = new PessoaModel(login);
		PessoaDTO pessoa = model.buscarPessoa(dto.getChavePessoa());
		pessoa.setSituacao("A");
		model.alterarPessoa(pessoa);
	}
	public Collection buscaDiretores(String nomeDiretor, String matriculaFuncional) {
		Collection result;
//		abreConexao(getDao(),dao);
		if(matriculaFuncional.equalsIgnoreCase("")){
			try {
				result = getDao().buscarDiretorPorNome(nomeDiretor);
				fechaConexao(dao);
				return result;
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}else{
			if(nomeDiretor.equalsIgnoreCase(""))
				try {
					result = getDao().buscarDiretorPorMatricula(matriculaFuncional);
					fechaConexao(dao);
					return result;
				} catch (SQLException e) {
					e.printStackTrace();
				}
				else{
					try {
						result = getDao().buscarDiretorPorNomeMatricula(nomeDiretor,matriculaFuncional);
						fechaConexao(dao);
						return result;
					} catch (SQLException e) {
						e.printStackTrace();
					}
				}
		}

		return null;
	}
	public DiretorDAO getDao() {
//		if(dao == null)
			try {
				dao = (DiretorDAO)DAOFactory.getInstance().getDAO("dao.DiretorDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return dao;
	}
	public DiretorDTO buscarDiretor(Integer chavePessoa) {
		try {
			DiretorDTO dto;
//			abreConexao(getDao(),dao);
			dto = getDao().buscarDiretor(chavePessoa);
			fechaConexao(dao);
			return dto;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
	public void excluirDiretor(Integer chavePessoa) {
		try {
//			abreConexao(getDao(),dao);
			getDao().excluirDiretor(chavePessoa);
			fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public void cadastrarDiretor(DiretorDTO dto) {
		try {
			if(dto.getSituacao().equalsIgnoreCase("A"))
				ativaPessoa(dto);
//			abreConexao(getDao(),dao);
			getDao().cadastrarDiretor(dto);
			fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public void alterarDadosCadastrais(DiretorDTO dto) {
		// TODO Auto-generated method stub
		try {
//			abreConexao(getDao(),dao);
			getDao().alterarDadosCadastrais(dto);
			fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
