/*
 * Created on 23/01/2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package model;

import java.sql.SQLException;
import java.util.Collection;

import dao.DAOFactory;
import dao.DisciplinaDAO;
import dto.DisciplinaDTO;
import dto.LoginDTO;

/**
 * @author daniel.freitas
 * 
 * To change the template for this generated type comment go to Window - Preferences - Java - Code
 * Generation - Code and Comments
 */
public class DisciplinaModel extends ModelBase{
	private DisciplinaDAO dao;

	public DisciplinaModel(LoginDTO login) {
		super(login);
	}

	public Collection listarTodasDisciplinas() throws SQLException {
		Collection result;
//		abreConexao(getDao(),dao);
		result = getDao().listarTodasDisciplinas();
		fechaConexao(dao);
		return result;
	}
	public void cadastrarDisciplina(DisciplinaDTO dto) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().cadastrarDisciplina(dto);
		fechaConexao(dao);
	}
	public void excluir(Integer codigoCurso) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().excluirDisciplina(codigoCurso);
		fechaConexao(dao);
	}
	public DisciplinaDTO buscarDisciplina(Integer idDisciplina) throws SQLException {
		DisciplinaDTO dto;
//		abreConexao(getDao(),dao);
		dto = getDao().buscarDisciplina(idDisciplina);
		fechaConexao(dao);
		return dto;
	}
	public void alterarDisciplina(DisciplinaDTO dto) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().alterarDisciplina(dto);
		fechaConexao(dao);
	}
	public Collection buscarDisciplinasPorParteDoNomeECurso(String nomeDisciplina, String nomeCurso)
	throws SQLException {
		Collection result;
//		abreConexao(getDao(),dao);
		result = getDao().buscarDisciplinasPorParteDoNomeECurso(nomeDisciplina, nomeCurso);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarDisciplinasPorParteDoNomeECursoEMonitor(String nomeDisciplina, String nomeCurso, Integer chaveMonitor)
	throws SQLException {
		Collection result;
//		abreConexao(getDao(),dao);
		result = getDao().buscarDisciplinasPorParteDoNomeECursoEMonitor(nomeDisciplina, nomeCurso, chaveMonitor);
		fechaConexao(dao);
		return result;
	}
	public Integer buscarIdUltimaDisciplinaCadastrada() throws SQLException {
		Integer result;
//		abreConexao(getDao(),dao);
		result = getDao().buscarIdUltimaDisciplinaCadastrada();
		fechaConexao(dao);
		return result;
	}

	public Collection buscarDisciplinasPorParteDoNomeECodigoDoCurso(String nomeDisciplina,
			Integer codigoCurso) throws SQLException {
		Collection result;
//		abreConexao(getDao(),dao);
		result = getDao().buscarDisciplinasPorParteDoNomeECodigoDoCurso(nomeDisciplina, codigoCurso);
		fechaConexao(dao);
		return result;
	}

	public DisciplinaDAO getDao() throws SQLException {
//		if (dao == null)
			try {
				dao = (DisciplinaDAO) DAOFactory.getInstance().getDAO("dao.DisciplinaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return dao;
	}

}