package model;

import java.sql.SQLException;

import dao.DAOFactory;
import dao.LoginDAO;
import dto.LoginDTO;
import dto.PessoaDTO;

public class LoginModel extends ModelBase{
	private LoginDAO dao;
	public LoginModel(LoginDTO login) {
		super(login);
	}
	
	public LoginDTO verificarLogin(LoginDTO dto) throws SQLException {
		//LoginDAO dao = getDao();
//		abreConexao(getDao(), dao);
		dto = getDao().verificarLogin(dto);
		fechaConexao(dao);
		return dto;		
	}
	
	public void alterarLogin(LoginDTO dto) throws SQLException{
//		abreConexao(getDao(), dao);
		getDao().alterarLogin(dto);
		fechaConexao(dao);
	}
	
	public void cadastrarLogin(LoginDTO dto) throws SQLException{
//		LoginDTO login = getDao().buscaLogin(dto.getLogin());
		
//		if(login!=null)
//			throw new SQLException();
//		abreConexao(getDao(), dao);
		getDao().cadastrarLogin(dto);
		fechaConexao(dao);
	}
	
	public LoginDTO buscarLogin(Integer chavePessoa) throws SQLException{
		LoginDTO dto;
//		abreConexao(getDao(), dao);
		dto = getDao().buscaLogin(chavePessoa);
		fechaConexao(dao);
//		dao = null;
		
		return dto;
	}
	
	public LoginDTO buscarLoginPeloLogin(String login) throws SQLException{
		LoginDTO dto;
//		abreConexao(getDao(), dao);
		dto = getDao().buscarLoginPeloLogin(login);
		fechaConexao(dao);
		return dto;
		
	}
	
	public LoginDAO getDao() throws SQLException {
	//		if(dao == null)
			try {
				dao = (LoginDAO)DAOFactory.getInstance().getDAO("dao.LoginDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				//se faz necessario para que trate l na visao
				System.out.println("Ops!!!!. \n" +
						"DAOFactory pode nao ter encontrado " +
						"usuario, senha, driver, ou url!!!");
				throw e;
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return dao;
	}
	
	public boolean VerificaImagem(String campoCaptcha, String imagemCaptcha){
		
		if (campoCaptcha != null && imagemCaptcha != null) {
			if (campoCaptcha.equals(imagemCaptcha)) {
				return true;
			}
		}
		
		return false;
	}
	
	public LoginDTO recoverLogin(PessoaDTO person) throws SQLException{
		LoginDTO dto = getDao().getLoginByMail(person.getEmail());
		fechaConexao(dao);
		return dto;
	}
}
