package model;

import java.sql.SQLException;
import java.util.Collection;

import dao.DAOFactory;
import dao.MonitorDAO;
import dto.AlunoDTO;
import dto.LoginDTO;
import dto.MonitorDTO;
import dto.PessoaDTO;

public class MonitorModel extends ModelBase{
	private MonitorDAO dao;
	private LoginDTO login;
	public MonitorModel(LoginDTO login) {
		super(login);
		this.login = login;
	}
	
	public Collection buscaMonitores(String nomeMonitor, String disciplina) {
		Collection result;
		if(disciplina.equalsIgnoreCase("")){
			try {
//				abreConexao(getDao(),dao);
				result = getDao().buscarMonitorPorNome(nomeMonitor);
				fechaConexao(dao);
				return result;
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}else{
			if(nomeMonitor.equalsIgnoreCase("")){
				try {
//					abreConexao(getDao(),dao);
					result = getDao().buscarMonitorPorDisciplina(disciplina);
					fechaConexao(dao);
					return result;
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}else{
				try {
//					abreConexao(getDao(),dao);
					result = getDao().buscarMonitorPorNomeDiscplina(nomeMonitor, disciplina);
					fechaConexao(dao);
					return result;
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			
		}
	
		
		return null;
	}
	public MonitorDAO getDao() {
//		if(dao == null)
			try {
				dao = (MonitorDAO)DAOFactory.getInstance().getDAO("dao.MonitorDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return dao;
	}
	public void cadastrarMonitor(MonitorDTO dto) {
		try {
//			abreConexao(getDao(),dao);
			getDao().cadastrarMonitor(dto);
			fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	public MonitorDTO buscarMonitor(Integer chavePessoa) {
		MonitorDTO dto;
		try {
//			abreConexao(getDao(),dao);
			dto = getDao().buscarMonitor(chavePessoa);
			fechaConexao(dao);
			return dto;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	return null;
	}
	public MonitorDTO buscarMonitorEmSemestreEspecifico(Integer chavePessoa, Integer idDisciplina, Integer ano, String semestre) {
		MonitorDTO dto;
		try {
//			abreConexao(getDao(),dao);
			dto = getDao().buscarMonitorEmSemestreEspecifico(chavePessoa, idDisciplina, ano, semestre);
			fechaConexao(dao);
			return dto;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	return null;
	}
	public Collection buscarDisciplinasComMonitoriasAtivasPorMonitor(Integer chavePessoa){
		Collection col;
		try {
//			abreConexao(getDao(),dao);
			col = getDao().buscarDisciplinasComMonitoriasAtivasPorMonitor(chavePessoa);
			fechaConexao(dao);
			return col;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	return null;
	}
	
	
	public void excluir(Integer chavePessoa, int disciplina, int ano, String semestre) {
		try {
//			abreConexao(getDao(),dao);
			getDao().excluir(chavePessoa, disciplina, ano, semestre);
			fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	public void alterarMonitor(MonitorDTO dto) {
		try {
			if(dto.getDtSaida() == null)
				ativaPessoa(dto);
//			abreConexao(getDao(),dao);
			getDao().alterarMonitor(dto);
			fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	private void ativaPessoa(MonitorDTO dto) throws SQLException {
		PessoaModel model = new PessoaModel(login);
		PessoaDTO pessoa = model.buscarPessoa(dto.getChavePessoa());
		pessoa.setSituacao("A");
		model.alterarPessoa(pessoa);
	}

	public void alterarMonitorSemestre(MonitorDTO dto, int chavePessoa,	int disciplina, int ano, String semestre) {
		try {
			if(dto.getDtSaida() == null)
				ativaPessoa(dto);
//			abreConexao(getDao(),dao);
			getDao().alterarMonitorSemestre(dto, chavePessoa, disciplina, ano, semestre);
			fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
		
	}
	


