package model;

import java.sql.Date;
import java.sql.SQLException;
import java.util.Collection;

import pmon.apoio.Data;


import dao.DAOFactory;
import dao.PessoaDAO;
import dto.AlunoDTO;
import dto.DiretorDTO;
import dto.LoginDTO;
import dto.MonitorDTO;
import dto.PessoaDTO;
import dto.ProfessorDTO;

public class PessoaModel extends ModelBase{
	private PessoaDAO dao;
	private LoginDTO login;
	public PessoaModel(LoginDTO login) {
		super(login);
		this.login = login;
	}

	public Collection listarTodasPessoas()throws SQLException{
//		abreConexao(getDao(),dao);

		Collection lista = getDao().listarTodasPessoas();

		fechaConexao(dao);
		return lista;

	}
	public void cadastrarPessoa(PessoaDTO dto)throws SQLException{
//		abreConexao(getDao(),dao);

		getDao().cadastrarPessoa(dto);

		fechaConexao(dao);
	}
	public void excluir(Integer chavePessoa)throws SQLException{
//		abreConexao(getDao(),dao);	
		getDao().excluirPessoa(chavePessoa);
		fechaConexao(dao);


	}

	public void alterarDadosCadastrais(PessoaDTO dto)throws SQLException{
//		abreConexao(getDao(),dao);
		getDao().alterarDadosCadastrais(dto);
		fechaConexao(dao);


	}
	public PessoaDTO buscarPessoa(Integer chavePessoa)throws SQLException {

//		abreConexao(getDao(),dao);

		PessoaDTO pessoa = getDao().buscarPessoa(chavePessoa); 

		fechaConexao(dao);
		return pessoa;

	}


	public PessoaDTO getUltimoInserido() throws SQLException{

//		abreConexao(getDao(),dao);

		PessoaDTO pessoa = getDao().getUltimoInserido(); 

		fechaConexao(dao);
		return pessoa;

	}

	public void alterarPessoa(PessoaDTO dto)throws SQLException{
//		abreConexao(getDao(),dao);
		if(dto.getSituacao().equalsIgnoreCase("I"))
			desativarPerfis(dto);
		getDao().alterarPessoa(dto);
		fechaConexao(dao);

	}

	private void desativarPerfis(PessoaDTO dto) throws SQLException {
//		abreConexao(getDao(),dao);
		AlunoModel alunoModel = new AlunoModel(login);
		ProfessorModel profModel = new ProfessorModel(login);
		MonitorModel monitorModel = new MonitorModel(login);
		DiretorModel diretorModel = new DiretorModel(login);
		if(profModel.buscarProfessor(dto.getChavePessoa()).getChavePessoa()!= null)
			desativarProfessor(profModel.buscarProfessor(dto.getChavePessoa()),profModel);
		if(alunoModel.buscarAluno(dto.getChavePessoa()).getChavePessoa()!= null)
			desativarAluno(alunoModel.buscarAluno(dto.getChavePessoa()),alunoModel);
		if(monitorModel.buscarMonitor(dto.getChavePessoa()).getChavePessoa()!= null)
			desativarMonitor(monitorModel.buscarMonitor(dto.getChavePessoa()),monitorModel);
		if(diretorModel.buscarDiretor(dto.getChavePessoa()).getChavePessoa()!=null)
			desativarDiretor(diretorModel.buscarDiretor(dto.getChavePessoa()),diretorModel);
//		fechaConexao(dao);
	}
	private void desativarProfessor(ProfessorDTO dto, ProfessorModel profModel){
		dto.setSituacao("I");
		profModel.alterarProfessor(dto);
	}
	private void desativarDiretor(DiretorDTO dto, DiretorModel diretorModel){
		dto.setSituacao("I");
		diretorModel.alterarDiretor(dto);
	}
	private void desativarAluno(AlunoDTO dto, AlunoModel alunoModel){
		dto.setSituacao("I");
		try {
			alunoModel.alterarAluno(dto);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	private void desativarMonitor(MonitorDTO dto, MonitorModel monitorModel){
		dto.setDtSaida(slave.Data.getDataSystem());
		monitorModel.alterarMonitor(dto);
	}
	public Collection buscarPessoasPorParteDoNome(String parametroBusca)throws SQLException {
//		abreConexao(getDao(),dao);
		Collection result = getDao().buscarPessoasPorParteDoNome(parametroBusca);
		fechaConexao(dao);
		return result;
	}


	public PessoaDAO getDao() throws SQLException {
//		if(dao == null)
		try {
			dao = (PessoaDAO)DAOFactory.getInstance().getDAO("dao.PessoaDAO",  getLoginDTOUsuarioLogado());
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			//se faz necessario para que trate l na visao
			System.out.println("Ops!!!!. \n" +
					"DAOFactory pode nao ter encontrado " +
			"usuario, senha, driver, ou url!!!");
			throw e;
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return dao;
	}

	public Collection buscarPessoasAtivas() throws SQLException {

		abreConexao(getDao(),dao);
		Collection result = dao.buscarPessoasAtivas();
		fechaConexao(dao);
		return result;
	}

	public Collection buscarPessoasAtivas(String parametroBusca) throws SQLException {
		abreConexao(getDao(),dao);
		Collection result = dao.buscarPessoasAtivas(parametroBusca);
		fechaConexao(dao);
		return result;
	}
}
