package model;

import java.sql.SQLException;
import java.util.Collection;

import com.sun.org.apache.bcel.internal.generic.GETSTATIC;

import dao.DAOFactory;
import dao.ProfessorDAO;
import dto.LoginDTO;
import dto.MonitorDTO;
import dto.PessoaDTO;
import dto.ProfessorDTO;


public class ProfessorModel extends ModelBase{
	private ProfessorDAO dao;
	private LoginDTO login;
	public ProfessorModel(LoginDTO login) {
		super(login);
		this.login = login;
	}
	
	public Collection buscaProfessores(String nomeProfessor, String disciplina) {
		Collection result = null;
		getDao();
		if(disciplina.equalsIgnoreCase("")){
			try {
				result = dao.buscarProfessorPorNome(nomeProfessor);
				fechaConexao(dao);
				return result;
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}else{
			if(nomeProfessor.equalsIgnoreCase("")){
				try {
					result = dao.buscarProfessorPorDiscplina(disciplina);
					fechaConexao(dao);
					return result;
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}else{
				try {
					result = dao.buscarProfessorPorNomeDiscplina(nomeProfessor,disciplina);
					fechaConexao(dao);
					return result;
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		return null;
	}
	public ProfessorDAO getDao() {
//		if(dao == null)
			try {
				dao = (ProfessorDAO)DAOFactory.getInstance().getDAO("dao.ProfessorDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return dao;
	}
	public ProfessorDTO buscarProfessor(Integer chavePessoa) {
		ProfessorDTO dto;
			try {
//				abreConexao(getDao(),dao);
				dto = getDao().buscarProfessor(chavePessoa);
				fechaConexao(dao);
				return dto;
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return null;
	}
	public void alterarProfessor(ProfessorDTO dto) {
		try {
			if(dto.getSituacao().equalsIgnoreCase("A"))
				ativaPessoa(dto);
			getDao().alterarProfessor(dto);
			fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	public void excluir(Integer chavePessoa) {
		try {
		   
			getDao().excluir(chavePessoa);
			fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	public void cadastraProfessor(ProfessorDTO dto) {
		try {
			if(dto.getSituacao().equalsIgnoreCase("A"))
				ativaPessoa(dto);
//			abreConexao(getDao(),dao);
			getDao().cadastrarProfessor(dto);
			fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public void alterarDadosCadastrais(ProfessorDTO dto) {
		try {
//			abreConexao(getDao(),dao);
			getDao().alterarDadosCadastrais(dto);
			fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	private void ativaPessoa(ProfessorDTO dto) throws SQLException {
		PessoaModel model = new PessoaModel(login);
		PessoaDTO pessoa = model.buscarPessoa(dto.getChavePessoa());
		pessoa.setSituacao("A");
		model.alterarPessoa(pessoa);
	}
}
