/*
 * Created on 23/01/2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package model;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collection;

import dao.DAOFactory;
import dao.TurmaDAO;
import dto.LoginDTO;
import dto.TurmaDTO;

/**
 * @author daniel.freitas
 * 
 * To change the template for this generated type comment go to Window - Preferences - Java - Code
 * Generation - Code and Comments
 */
public class TurmaModel extends ModelBase{
	private TurmaDAO dao;
	
	public TurmaModel(LoginDTO login) {
		super(login);
	}

	public Collection listarTodasTurmas() throws SQLException {
//		abreConexao(getDao(),dao);
		Collection result = getDao().listarTodasTurmas();
		fechaConexao(dao);
		return result;
		
	}

	public void cadastrarTurma(TurmaDTO dto) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().cadastrarTurma(dto);
		fechaConexao(dao);		
	}

	public void excluir(String codigoTurma, Integer codigoCurso, Integer idDisciplina, Integer ano,
			Integer semestre) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().excluirTurma(codigoTurma, codigoCurso, idDisciplina, ano, semestre);
		fechaConexao(dao);
		
	}

	public TurmaDTO buscarTurma(String codigoTurma, Integer codigoCurso, Integer idDisciplina,
			Integer ano, String semestre) throws SQLException {
//		abreConexao(getDao(),dao);
		TurmaDTO result = getDao().buscarTurma(codigoTurma, codigoCurso, idDisciplina, ano, semestre);
		fechaConexao(dao);
		return result;
	}

	public void alterarTurma(TurmaDTO dto) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().alterarTurma(dto);
		fechaConexao(dao);
		
	}

	public Collection buscarTurmasPorCodigoEDisciplina(String parteCodigo, String nomeDisciplina, String ano, String semestre)
			throws SQLException, ParseException {
//		abreConexao(getDao(),dao);
		Collection result = getDao().buscarTurmasPorCodigoEDisciplina(parteCodigo, nomeDisciplina,ano,semestre);
		fechaConexao(dao);
		return result;
	}
	
	public Collection buscarTurmasPorCodigoEDisciplinaEChaveAluno(String parteCodigo, String nomeDisciplina, String ano, String semestre, String chaveAluno)
			throws SQLException, ParseException {
//		abreConexao(getDao(),dao);
		Collection result = getDao().buscarTurmasPorCodigoEDisciplinaEChaveAluno(parteCodigo, nomeDisciplina,ano,semestre, chaveAluno);
		fechaConexao(dao);
		return result;
	}
	
	public Collection buscarTurmasPorCodigoEDisciplinaEMonitor(String parteCodigo, String nomeDisciplina, String ano, String semestre, String chaveMonitor)
			throws SQLException, ParseException {
//		abreConexao(getDao(),dao);
		Collection result = getDao().buscarTurmasPorCodigoEDisciplinaEMonitor(parteCodigo, nomeDisciplina,ano,semestre, chaveMonitor);
		fechaConexao(dao);
		return result;
		
	}

	public TurmaDAO getDao() throws SQLException {
//		if (dao == null)
			try {
				dao = (TurmaDAO) DAOFactory.getInstance().getDAO("dao.TurmaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return dao;
	}

}