package pmon.acao.atendimento;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.ConteudoModel;

import dto.LoginDTO;

import pmon.dto.AtendimentoPesquisaDTO;
import pmon.model.*;
import acao.Acao;

public class AbreAtendimentoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		// TODO Auto-generated method stub
		req.getSession().setAttribute("contexto","Atendimento");
		req.getSession().setAttribute("execucao","Pesquisar");
		if((Collection)req.getAttribute("atendimentos") == null){
			Collection col = new ArrayList();
			req.setAttribute("atendimentos",col);
			
		}
		if((AtendimentoPesquisaDTO)req.getAttribute("pesquisa") == null){
			AtendimentoPesquisaDTO pesquisa = new AtendimentoPesquisaDTO();
			req.setAttribute("pesquisa",pesquisa);
			
		}
		
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		
		ProfessorModel proModel  = new ProfessorModel(login);
		DisciplinaModel disciplinaModel = new DisciplinaModel(login);
		ConteudoModel conteudoModel = new ConteudoModel(login);
		MonitorModel monitorModel = new MonitorModel(login);
		
		req.setAttribute("professores", proModel.listarProfessores());
		req.setAttribute("disciplinas", disciplinaModel.listarDisciplinas());
		req.setAttribute("conteudos", conteudoModel.listarTodosConteudos());
		req.setAttribute("monitores", monitorModel.listarMonitoresDistinct());
		
		
		return "/jsp/pmon/atendimento/pesquisaAtendimento.jsp";
	}

}
