package pmon.acao.atendimento;

import javax.servlet.http.*;

import model.ConteudoModel;

import dto.LoginDTO;

import pmon.apoio.MessageErrorAtendimento;
import pmon.dto.AtendimentoDTO;
import pmon.model.*;
import acao.Acao;

public class AbrirAlteraAtendimentoAcao implements Acao {

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		secao.setAttribute("execucao","Alterar");
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		
		ProfessorModel proModel  = new ProfessorModel(login);
		DisciplinaModel disciplinaModel = new DisciplinaModel(login);
		ConteudoModel conteudoModel = new ConteudoModel(login);
		MonitorModel monitorModel = new MonitorModel(login);
		AlunoModel alunoModel = new AlunoModel(login);
		
		req.getSession().setAttribute("alunos", alunoModel.listarAlunos());		
		req.getSession().setAttribute("professores", proModel.listarProfessores());
		req.getSession().setAttribute("disciplinas", disciplinaModel.listarDisciplinas());
		req.getSession().setAttribute("conteudos", conteudoModel.listarTodosConteudos());
		req.getSession().setAttribute("monitores", monitorModel.listarMonitores());

		AtendimentoDTO dto;
		AtendimentoModel model = new AtendimentoModel(login);
		int id = Integer.parseInt(req.getParameter("chaveAtendimento"));
		dto = model.buscaAtendimentoPorId(id);
		req.setAttribute("atendimento", dto);
			
		if(req.getAttribute("erro") == null){
			MessageErrorAtendimento mea = new MessageErrorAtendimento();
			req.setAttribute("erro",mea);
		}
		
		
		return "/jsp/pmon/atendimento/alteraAtendimento.jsp";
	}

}
