package pmon.acao.atendimento;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import pmon.apoio.MessageErrorAtendimento;
import pmon.dto.AtendimentoDTO;
import pmon.model.*;
import model.ConteudoModel;
import acao.Acao;

public class AbrirCadastroAtendimentoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		
		ProfessorModel proModel  = new ProfessorModel(login);
		DisciplinaModel disciplinaModel = new DisciplinaModel(login);
		MonitorModel monitorModel = new MonitorModel(login);
		AlunoModel alunoModel = new AlunoModel(login);
		ConteudoModel conteudoModel = new ConteudoModel(login);

		req.setAttribute("alunos", alunoModel.listarAlunos());
		req.setAttribute("professores", proModel.listarProfessores());
		req.setAttribute("disciplinas", disciplinaModel.listarDisciplinas());
		req.setAttribute("conteudos", conteudoModel.listarTodosConteudos());
		req.setAttribute("monitores", monitorModel.listarMonitores());
		
		req.getSession().setAttribute("execucao","Cadastrar");
		
		if(req.getAttribute("erro") == null){
			MessageErrorAtendimento mea = new MessageErrorAtendimento();
			req.setAttribute("erro",mea);
		}
		if(req.getAttribute("atendimentoErro") == null){
			AtendimentoDTO at = new AtendimentoDTO();
			req.setAttribute("atendimentoErro",at);
		}
		
		
		return "/jsp/pmon/atendimento/cadastroAtendimento.jsp";
	}
}
