package pmon.acao.atendimento;

import java.sql.Date;
import java.text.SimpleDateFormat;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import pmon.apoio.MessageErrorAtendimento;
import pmon.apoio.ValidacaoAtendimento;
import pmon.dto.AtendimentoDTO;
import pmon.model.AtendimentoModel;
import pmon.model.ParecerModel;
import slave.Dominio;
import dto.LoginDTO;
import dto.MonitorDTO;

public class AlteraAtendimentoAcao implements acao.Acao {

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		Integer perfil = (Integer)req.getSession().getAttribute("perfil");
		MonitorDTO monitor = (MonitorDTO)req.getSession().getAttribute("monitor");
		int chaveMonitor = Integer.parseInt(req.getParameter("chaveMonitor").toString());
		
		
// se nofor um monitor ou se no for o monitor que fez o atendimento vai pro login		
		if((perfil.intValue()!=5)||
		   (monitor.getChavePessoa().intValue()!= chaveMonitor)){
			return "/index.do";
		}
		if((perfil.intValue()!=5)||
				   (monitor.getChavePessoa().intValue()!= chaveMonitor)){
					return "/index.do";
				}
//		***************Validao
		MessageErrorAtendimento mea = new MessageErrorAtendimento();
		try{
			ValidacaoAtendimento.validaAlteracao(req,mea);
		}catch (Exception e) {
			req.setAttribute("erro",mea);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			e.printStackTrace();
			return "/jsp/pmon/atendimento/alteraAtendimento.jsp";
		}
//***********************************************************************
		
	
		AtendimentoModel model = new AtendimentoModel(login);
		ParecerModel parecerModel = new ParecerModel(login);
		AtendimentoDTO dto = new AtendimentoDTO();
				
		dto.setIdAtendimento(Integer.parseInt(req.getParameter("idAtendimento").toString()));
		dto.setDuracao(Integer.parseInt(req.getParameter("duracao").toString()));
		dto.getParecer().setParecerMonitor(req.getParameter("parecerMonitor").toString());

		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		if(!req.getParameter("data").toString().equals("")){
			java.util.Date dtAtendimento = sdf.parse(req.getParameter("data"));
			dto.setDataAtendimento(new Date(dtAtendimento.getTime()));
		}
		else{
			dto.setDataAtendimento(null);
		}
		if(req.getParameter("notificarProfessor")!= null){//verificar se est checado
			dto.getParecer().setNotificar('S');
		}
		else{
			dto.getParecer().setNotificar('N');
		}
		if(req.getParameter("presencial")!= null){//verificar se est checado
			dto.setLocalAtendimento('D');
		}
		else{
			dto.setLocalAtendimento('P');
		}
		dto.setIdConteudo(Integer.parseInt(req.getParameter("conteudo").toString()));
		model.alterarAtendimento(dto);
		dto.getParecer().setIdAtendimento(dto.getIdAtendimento());
		if(parecerModel.temParecer(dto.getIdAtendimento())){
		   parecerModel.alterarParecer(dto.getParecer());
		}else{
			if(!dto.getParecer().getParecerMonitor().equals("")){
				parecerModel.cadastrar(dto.getParecer());
			}
		}
		
		if(dto.getParecer().isNotificar()){
			//invocar a acao p notificar
			return "/visualizaAtendimento.do?chaveAtendimento="+dto.getIdAtendimento();	
		}else{
			return "/visualizaAtendimento.do?chaveAtendimento="+dto.getIdAtendimento();
		}
	}

}
