package pmon.acao.atendimento;

import java.sql.Date;
import java.text.SimpleDateFormat;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import pmon.apoio.MessageErrorAtendimento;
import pmon.apoio.ValidacaoAtendimento;
import pmon.dto.AtendimentoDTO;
import pmon.model.AtendimentoModel;
import pmon.model.ParecerModel;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;
import dto.MonitorDTO;

public class CadastroAtendimentoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
//		***************Validao
		MessageErrorAtendimento mea = new MessageErrorAtendimento();

		try{
			ValidacaoAtendimento.valida(req,mea);
		}catch (Exception e) {
			req.setAttribute("erro",mea);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			e.printStackTrace();
			return "/abrirCadastroAtendimento.do";
		}
		//***********************************************************************
		String msg = "O Atendimento foi cadastrado com sucesso";
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		
		AtendimentoModel model = new AtendimentoModel(login);
		ParecerModel parecerModel = new ParecerModel(login);
		
		AtendimentoDTO dto = new AtendimentoDTO();
		MonitorDTO monitor = (MonitorDTO)req.getSession().getAttribute("monitor");
		dto.setCPMonitor(monitor.getChavePessoa().intValue());
		//buscar a chave do monitor
		//dto.setCPMonitor(7);
		dto.setIdDisciplina(Integer.parseInt(req.getParameter("disciplina").toString()));
		dto.setCPAluno(Integer.parseInt(req.getParameter("aluno").toString()));
		dto.setIdConteudo(Integer.parseInt(req.getParameter("conteudo").toString()));
		dto.setDuracao(Integer.parseInt(req.getParameter("duracao").toString()));
		dto.getParecer().setParecerMonitor(req.getParameter("parecerMonitor").toString());
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		if(!req.getParameter("data").toString().equals("")){
			java.util.Date dtAtendimento = sdf.parse(req.getParameter("data"));
			dto.setDataAtendimento(new Date(dtAtendimento.getTime()));
		}
		if(req.getParameter("notificarProfessor")!= null){//verificar se est checado
			dto.getParecer().setNotificar('S');
		}
		else{
			dto.getParecer().setNotificar('N');
		}
		if(req.getParameter("presencial")!= null){//verificar se est checado
			dto.setLocalAtendimento('D');
		}
		else{
			dto.setLocalAtendimento('P');
		}
		if(model.cadastrar(dto)&&(!dto.getParecer().getParecerMonitor().trim().equals(""))){
	    	dto.getParecer().setIdAtendimento(model.getUltimoInserido());
	 	    parecerModel.cadastrar(dto.getParecer());
		}
		
		
		req.setAttribute("msg", msg);
		
		if(dto.getParecer().isNotificar()){
		
			return "/abreAtendimento.do";	
		}else{
			return "/abreAtendimento.do";
		}

	}
}
