package pmon.acao.atendimento;

import java.util.Collection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.MonitorModel;

import pmon.dto.AtendimentoDTO;
import pmon.model.AtendimentoModel;
import acao.Acao;
import dto.LoginDTO;
import dto.MonitorDTO;

public class VisualizaAtendimentoAcao implements Acao{

	
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		AtendimentoDTO dto;
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		AtendimentoModel model = new AtendimentoModel(login);
		MonitorModel monitorModel =  new MonitorModel(login);
	
		dto = model.buscaAtendimentoPorId(Integer.parseInt(req.getParameter("chaveAtendimento")));
		
		
		if(login.getPerfil().intValue()== 3){ //professor
			if(dto.getParecer().getNotificar() == 'S'){
				dto.getParecer().setNotificar('P');
				model.alteraStatusParecer('P',dto.getIdAtendimento());
			}
		}
		
		if(login.getPerfil().intValue()== 5){ //monitor
				
			Collection DisciplinasDoMonitor = monitorModel.buscarDisciplinasComMonitoriasAtivasPorMonitor(login.getChavePessoa());
			boolean podeVerParecer = false;
			
			for (Iterator iterator = DisciplinasDoMonitor.iterator(); iterator.hasNext();) {
				MonitorDTO mDto = (MonitorDTO) iterator.next();
				if(mDto.getIdDisciplina() == dto.getIdDisciplina() || dto.getCPMonitor() == login.getChavePessoa()){
						podeVerParecer = true;
				}
			}
			if(dto.getCPMonitor() != login.getChavePessoa()){
				dto.getParecer().setParecerMonitor("");
			}
			if (!podeVerParecer){
				System.out.println("no pode ver");
				dto.getParecer().setParecerProfessor("");
				dto.getParecer().setNotificar('N');
			}
			if(dto.getParecer().getNotificar() == 'R' & podeVerParecer){
				dto.getParecer().setNotificar('M');
				model.alteraStatusParecer('M',dto.getIdAtendimento());
			}	
		}
		
		String execucao = (String)req.getSession().getAttribute("execucao");
		if(!execucao.equals("Excluir")){
			req.getSession().setAttribute("execucao","Visualizar");
		}
		req.setAttribute("atendimento", dto);
		System.out.println(dto.getParecer().getParecerProfessor());
		return "/jsp/pmon/atendimento/visualizaAtendimento.jsp";
	}

}
