
package pmon.acao.frequencia;

import java.util.Collection;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import pmon.dto.*;
import pmon.model.*;
import acao.Acao;
import dto.LoginDTO;
import dto.MonitorDTO;


public class PesquisaFrequenciaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		// TODO Auto-generated method stub
		Integer perfil = (Integer)req.getSession().getAttribute("perfil");
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");

		if(perfil.intValue() != 2){//se nao for aluno
			FrequenciaModel model = new FrequenciaModel(login);
			
			req.getSession().setAttribute("execucao", "Pesquisar");
			if(perfil.intValue() == 5){
				MonitorDTO monitor = (MonitorDTO) req.getSession().getAttribute("monitor");
				FrequenciaDTO dto ;

				Date data = new Date();
				java.sql.Date dataSQL = new java.sql.Date(data.getTime());
				dto = model.buscarEntrada(monitor.getChavePessoa().intValue(), dataSQL);
				req.setAttribute("acaoMonitor", "Pesquisa");
				req.getSession().setAttribute("execucao", "Pesquisar");
				req.getSession().setAttribute("frequencia",dto);
				Collection frqs =  model.listarFrequenciaPorMonitor(monitor.getChavePessoa().intValue());
				req.getSession().setAttribute("frequencias",frqs);
				return "/jsp/pmon/frequencia/pesquisaFrequenciaMon.jsp";
			}
			DisciplinaModel disciplinaModel = new DisciplinaModel(login);
			MonitorModel monitorModel = new MonitorModel(login);
			FrequenciaPesquisaDTO dto = new FrequenciaPesquisaDTO(req);
			
			req.setAttribute("pesquisa",dto);
			req.setAttribute("disciplinas", disciplinaModel.listarDisciplinas());
			req.setAttribute("monitores", monitorModel.listarMonitoresDistinct());
			req.setAttribute("frequencias", model.pesquisarFrequencia(dto));
			
			System.out.println("foi p a pagina");
			return "/jsp/pmon/frequencia/pesquisaFrequenciaAdm.jsp";
		}
		return "/index.do";
	}
}
