package pmon.acao.frequencia;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import pmon.apoio.*;
import pmon.dto.FrequenciaDTO;
import pmon.model.FrequenciaModel;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;
import dto.MonitorDTO;

public class RegistrarFrequenciaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
//		***************Validao
		MessageErrorFrequencia mef = new MessageErrorFrequencia();

		try{
			ValidacaoFrequencia.valida(req,mef);
		}catch (Exception e) {
			req.setAttribute("erro",mef);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			e.printStackTrace();
			return "/novaFrequencia.do?" + req.getParameter("tipo");
		}
		//***********************************************************************
			    
		MonitorDTO monitor = (MonitorDTO)req.getSession().getAttribute("monitor");
		FrequenciaDTO dto = (FrequenciaDTO)req.getSession().getAttribute("frequencia");
		FrequenciaModel model = new FrequenciaModel(login);
		
		if(dto.isEntrada()){
			dto.setChavePessoaMonitor(monitor.getChavePessoa().intValue());
			dto.setData(new java.sql.Date(new java.util.Date().getTime()));
			dto.setHoraEntrada(Data.getHora());
			dto.setAutenticaEntrada(req.getParameter("ip"));
			dto.setAutenticaSaida(null);
			dto.setHoraSaida(null);
			
			model.registrarEntrada(dto);
		}else{
			dto.setAutenticaSaida(req.getParameter("ip"));
			dto.setHoraSaida(Data.getHora());
			model.registrarSaida(dto);
		}
		req.getSession().setAttribute("execucao","Pesquisar");
		req.setAttribute("acaoMonitor","Pesquisa");
		req.getSession().removeAttribute("frequencia");
		return "/abreFrequencia.do";
		
	}
}
